/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.node.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.node.ConfiguredNodeImplementation;
import org.apache.tuscany.sca.implementation.node.NodeImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredNodeImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ConfiguredNodeImplementation> {
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final QName FEED_QNAME = new QName("http://www.w3.org/2005/Atom", "feed");
    private static final QName ENTRY_QNAME = new QName("http://www.w3.org/2005/Atom", "entry");
    private static final QName ID_QNAME = new QName("http://www.w3.org/2005/Atom", "id");
    private static final QName LINK_QNAME = new QName("http://www.w3.org/2005/Atom", "link");
    private static final String HREF = "href";
    private ContributionFactory contributionFactory;
    private AssemblyFactory assemblyFactory;
    private NodeImplementationFactory implementationFactory;

    public ConfiguredNodeImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(NodeImplementationFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<ConfiguredNodeImplementation> getModelType() {
        return ConfiguredNodeImplementation.class;
    }

    @Override
    public ConfiguredNodeImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ConfiguredNodeImplementation implementation = this.implementationFactory.createConfiguredNodeImplementation();
        implementation.setUnresolved(true);
        Composite composite = null;
        Artifact contribution = null;
        boolean id = false;
        QName name = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (ENTRY_QNAME.equals(name)) {
                        if (implementation.getComposite() == null) {
                            composite = this.assemblyFactory.createComposite();
                            break;
                        }
                        contribution = this.contributionFactory.createContribution();
                        break;
                    }
                    if (ID_QNAME.equals(name)) {
                        id = true;
                        break;
                    }
                    if (!LINK_QNAME.equals(name)) break;
                    String href = this.getString(reader, HREF);
                    if (composite != null) {
                        composite.setURI(href);
                        break;
                    }
                    if (contribution == null) break;
                    contribution.setLocation(href);
                    break;
                }
                case 4: {
                    if (!id || contribution == null) break;
                    contribution.setURI(reader.getText());
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (ENTRY_QNAME.equals(name)) {
                        if (composite != null) {
                            implementation.setComposite(composite);
                        } else if (contribution != null) {
                            implementation.getContributions().add((Contribution)contribution);
                        }
                        composite = null;
                        contribution = null;
                        break;
                    }
                    if (ID_QNAME.equals(name)) {
                        id = false;
                        break;
                    }
                    if (!FEED_QNAME.equals(name)) break;
                    return implementation;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return implementation;
    }

    @Override
    public void resolve(ConfiguredNodeImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        Composite composite = implementation.getComposite();
        if (composite != null && !(composite = resolver.resolveModel(Composite.class, composite)).isUnresolved()) {
            implementation.setComposite(composite);
        }
        List<Contribution> contributions = implementation.getContributions();
        int n = contributions.size();
        for (int i = 0; i < n; ++i) {
            Contribution contribution = contributions.get(i);
            if ((contribution = resolver.resolveModel(Contribution.class, contribution)).isUnresolved()) continue;
            contributions.set(i, contribution);
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(ConfiguredNodeImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
    }
}

