/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.notification;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.implementation.notification.ImmutableMessage;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationComponentInvoker
implements Invoker {
    private static final Message RESPONSE = new ImmutableMessage();
    private List<InvocationChain> subscriberInvocationChains = null;
    private Operation operation;
    private RuntimeComponent component;

    public NotificationComponentInvoker(Operation operation, RuntimeComponent component) {
        this.operation = operation;
        this.component = component;
    }

    @Override
    public Message invoke(Message msg) {
        this.addSubscriberInvocationChains();
        Object msgBody = msg.getBody();
        for (InvocationChain subscriberInvocationChain : this.subscriberInvocationChains) {
            Invoker chainInvoker = subscriberInvocationChain.getHeadInvoker();
            msg.setBody(msgBody);
            chainInvoker.invoke(msg);
        }
        return RESPONSE;
    }

    private void addSubscriberInvocationChains() {
        if (this.subscriberInvocationChains == null) {
            this.subscriberInvocationChains = new ArrayList<InvocationChain>();
            for (ComponentReference reference : this.component.getReferences()) {
                if (reference.getName().indexOf("$self$") >= 0) continue;
                RuntimeComponentReference rtCompRef = null;
                if (!(reference instanceof RuntimeComponentReference)) {
                    throw new RuntimeException("Need a runtime component reference");
                }
                rtCompRef = (RuntimeComponentReference)reference;
                for (RuntimeWire wire : rtCompRef.getRuntimeWires()) {
                    List<InvocationChain> chains = wire.getInvocationChains();
                    InvocationChain chain = this.getInvocationChain(chains, this.operation);
                    this.subscriberInvocationChains.add(chain);
                }
            }
        }
    }

    private InvocationChain getInvocationChain(List<InvocationChain> chains, Operation operation) {
        InvocationChain chain = null;
        for (InvocationChain ch : chains) {
            if (!ch.getTargetOperation().equals(operation)) continue;
            chain = ch;
            break;
        }
        if (chain == null) {
            for (InvocationChain ch : chains) {
                if (!ch.getTargetOperation().getName().equals(operation.getName())) continue;
                chain = ch;
                break;
            }
            if (chain == null) {
                throw new RuntimeException("Can't find a compatible chain");
            }
        }
        return chain;
    }
}

