/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.impl;

import java.util.Hashtable;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.osgi.OSGiImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiImplementationImpl
extends ImplementationImpl
implements OSGiImplementation {
    private String bundleSymbolicName;
    private String bundleVersion;
    private String[] imports;
    private Hashtable<String, List<ComponentProperty>> referenceProperties;
    private Hashtable<String, List<ComponentProperty>> serviceProperties;
    private Hashtable<String, List<ComponentProperty>> referenceCallbackProperties;
    private Hashtable<String, List<ComponentProperty>> serviceCallbackProperties;
    private String[] classList;
    private ModelFactoryExtensionPoint modelFactories;
    private Object osgiBundle;

    public OSGiImplementationImpl(ModelFactoryExtensionPoint modelFactories, String bundleSymbolicName, String bundleVersion, String[] imports, String[] classList, Hashtable<String, List<ComponentProperty>> refProperties, Hashtable<String, List<ComponentProperty>> serviceProperties) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.bundleVersion = bundleVersion;
        this.imports = imports;
        this.referenceProperties = refProperties;
        this.serviceProperties = serviceProperties;
        this.classList = classList;
        this.modelFactories = modelFactories;
    }

    public void setCallbackProperties(Hashtable<String, List<ComponentProperty>> refCallbackProperties, Hashtable<String, List<ComponentProperty>> serviceCallbackProperties) {
        this.referenceCallbackProperties = refCallbackProperties;
        this.serviceCallbackProperties = serviceCallbackProperties;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    @Override
    public String getBundleVersion() {
        return this.bundleVersion;
    }

    @Override
    public String[] getImports() {
        return this.imports;
    }

    public String[] getClassList() {
        return this.classList;
    }

    public ModelFactoryExtensionPoint getModelFactories() {
        return this.modelFactories;
    }

    @Override
    public List<ComponentProperty> getReferenceProperties(String referenceName) {
        return this.referenceProperties.get(referenceName);
    }

    @Override
    public List<ComponentProperty> getServiceProperties(String serviceName) {
        return this.serviceProperties.get(serviceName);
    }

    public List<ComponentProperty> getReferenceCallbackProperties(String referenceName) {
        return this.referenceCallbackProperties.get(referenceName);
    }

    public List<ComponentProperty> getServiceCallbackProperties(String serviceName) {
        return this.serviceCallbackProperties.get(serviceName);
    }

    public boolean isAllowsPassByReference() {
        return true;
    }

    public Object getOSGiBundle() {
        return this.osgiBundle;
    }

    public void setOSGiBundle(Object osgiBundle) {
        this.osgiBundle = osgiBundle;
    }

    private boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OSGiImplementationImpl)) {
            return super.equals(obj);
        }
        OSGiImplementationImpl impl = (OSGiImplementationImpl)obj;
        if (!this.areEqual(this.bundleSymbolicName, impl.bundleSymbolicName)) {
            return false;
        }
        if (!this.areEqual(this.bundleVersion, impl.bundleVersion)) {
            return false;
        }
        if (!this.areEqual(this.serviceProperties, impl.serviceProperties)) {
            return false;
        }
        if (!this.areEqual(this.serviceCallbackProperties, impl.serviceCallbackProperties)) {
            return false;
        }
        if (!this.areEqual(this.referenceProperties, impl.referenceProperties)) {
            return false;
        }
        if (!this.areEqual(this.referenceCallbackProperties, impl.referenceCallbackProperties)) {
            return false;
        }
        return super.equals(obj);
    }
}

