/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.JDKProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.osgi.OSGiImplementation;
import org.apache.tuscany.sca.implementation.osgi.context.OSGiAnnotations;
import org.apache.tuscany.sca.implementation.osgi.impl.OSGiImplementationImpl;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiInstanceWrapper;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiRemotableInvoker;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiTargetInvoker;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiImplementationProvider
implements ScopedImplementationProvider,
FrameworkListener,
BundleListener {
    private static final String COMPONENT_SERVICE_NAME = "component.service.name";
    private static final long METHOD_TIMEOUT_MILLIS = 60000L;
    private static final long SERVICE_TIMEOUT_MILLIS = 300000L;
    private OSGiImplementationImpl implementation;
    private OSGiAnnotations osgiAnnotations;
    private BundleContext bundleContext;
    private Hashtable<RuntimeWire, Reference> referenceWires = new Hashtable();
    private Hashtable<RuntimeWire, ComponentReference> componentReferenceWires = new Hashtable();
    private HashSet<RuntimeWire> resolvedWires = new HashSet();
    private boolean wiresResolved;
    private AtomicInteger startBundleEntryCount = new AtomicInteger();
    private AtomicInteger processAnnotationsEntryCount = new AtomicInteger();
    private JavaPropertyValueObjectFactory propertyValueFactory;
    private Hashtable<String, Object> componentProperties = new Hashtable();
    private RuntimeComponent runtimeComponent;
    private Bundle osgiBundle;
    private ArrayList<Bundle> dependentBundles = new ArrayList();
    private OSGiServiceListener osgiServiceListener;
    private PackageAdmin packageAdmin;
    private OSGiRuntime osgiRuntime;
    private ScopeRegistry scopeRegistry;
    private DataBindingExtensionPoint dataBindingRegistry;
    private boolean packagesRefreshed;
    private MessageFactory messageFactory;
    private InterfaceContractMapper mapper;

    public OSGiImplementationProvider(RuntimeComponent definition, OSGiImplementation impl, DataBindingExtensionPoint dataBindingRegistry, JavaPropertyValueObjectFactory propertyValueFactory, ProxyFactory proxyFactory, ScopeRegistry scopeRegistry, RequestContextFactory requestContextFactory, MessageFactory messageFactory, InterfaceContractMapper mapper) throws BundleException {
        this.implementation = (OSGiImplementationImpl)impl;
        this.runtimeComponent = definition;
        this.dataBindingRegistry = dataBindingRegistry;
        this.propertyValueFactory = propertyValueFactory;
        this.scopeRegistry = scopeRegistry;
        this.messageFactory = messageFactory;
        this.mapper = mapper;
        this.bundleContext = this.getBundleContext();
        this.osgiBundle = (Bundle)this.implementation.getOSGiBundle();
        this.bundleContext.addBundleListener((BundleListener)this);
        this.osgiServiceListener = new OSGiServiceListener(this.osgiBundle);
        this.bundleContext.addServiceListener((ServiceListener)this.osgiServiceListener);
        String[] imports = this.implementation.getImports();
        for (int i = 0; i < imports.length; ++i) {
            String location = imports[i].trim();
            if (location.length() <= 0) continue;
            Bundle bundle = this.bundleContext.installBundle(location);
            this.dependentBundles.add(bundle);
        }
        this.osgiAnnotations = new OSGiAnnotations(this.implementation.getModelFactories(), this.implementation.getClassList(), this.runtimeComponent, propertyValueFactory, proxyFactory, requestContextFactory, this.osgiBundle, this.dependentBundles);
        ServiceReference packageAdminReference = this.bundleContext.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (packageAdminReference != null) {
            this.packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
            this.bundleContext.addFrameworkListener((FrameworkListener)this);
        }
    }

    protected RuntimeComponent getRuntimeComponent() {
        return this.runtimeComponent;
    }

    protected OSGiImplementationImpl getImplementation() {
        return this.implementation;
    }

    private void processProperties(List<?> props, Hashtable<String, Object> propsTable) {
        if (props != null) {
            for (Object p : props) {
                Property prop = (Property)p;
                Class javaType = SimpleTypeMapperImpl.getJavaType(prop.getXSDType());
                ObjectFactory objFactory = this.propertyValueFactory.createValueFactory(prop, prop.getValue(), javaType);
                Object value = objFactory.getInstance();
                propsTable.put(prop.getName(), value);
            }
        }
    }

    private BundleContext getBundleContext() throws BundleException {
        try {
            if (this.bundleContext == null) {
                this.osgiRuntime = OSGiRuntime.getRuntime();
                this.bundleContext = this.osgiRuntime.getBundleContext();
            }
        }
        catch (BundleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BundleException("Could not start OSGi runtime", (Throwable)e);
        }
        return this.bundleContext;
    }

    private String getOSGiFilter(Hashtable<String, Object> props) {
        String filter = "";
        if (props != null && props.size() > 0) {
            int propCount = 0;
            for (String propName : props.keySet()) {
                if (propName.equals("service.pid")) continue;
                filter = filter + "(" + propName + "=" + props.get(propName) + ")";
                ++propCount;
            }
            if (propCount > 1) {
                filter = "(&" + filter + ")";
            }
        } else {
            filter = null;
        }
        return filter;
    }

    private ServiceReference getOSGiServiceReference(String scaServiceName, String osgiServiceName, String filter) throws InvalidSyntaxException {
        String compServiceName = this.runtimeComponent.getName() + "/" + scaServiceName;
        if (filter != null && filter.length() > 0) {
            ServiceReference[] references = this.bundleContext.getServiceReferences(osgiServiceName, filter);
            ServiceReference reference = null;
            if (references != null) {
                for (ServiceReference ref : references) {
                    if (ref.getBundle() != this.osgiBundle) continue;
                    Object compName = ref.getProperty(COMPONENT_SERVICE_NAME);
                    if (compName == null && reference == null) {
                        reference = ref;
                    }
                    if (scaServiceName != null && !compServiceName.equals(compName)) continue;
                    reference = ref;
                    break;
                }
            }
            return reference;
        }
        filter = scaServiceName == null ? null : "(component.service.name=" + compServiceName + ")";
        ServiceReference[] references = this.bundleContext.getServiceReferences(osgiServiceName, filter);
        if (references != null) {
            for (ServiceReference ref : references) {
                if (ref.getBundle() != this.osgiBundle) continue;
                return ref;
            }
        }
        references = this.bundleContext.getServiceReferences(osgiServiceName, null);
        ServiceReference reference = null;
        if (references != null) {
            for (ServiceReference ref : references) {
                if (ref.getBundle() != this.osgiBundle) continue;
                Object compName = ref.getProperty(COMPONENT_SERVICE_NAME);
                if (compName == null && reference == null) {
                    reference = ref;
                }
                if (!compServiceName.equals(compName)) continue;
                reference = ref;
                break;
            }
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterMethod(boolean doWait, AtomicInteger entryCount) {
        if (entryCount.compareAndSet(0, 1)) {
            return true;
        }
        if (doWait) {
            AtomicInteger atomicInteger = entryCount;
            synchronized (atomicInteger) {
                if (entryCount.get() != 2) {
                    try {
                        entryCount.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitMethod(AtomicInteger entryCount) {
        entryCount.compareAndSet(1, 2);
        AtomicInteger atomicInteger = entryCount;
        synchronized (atomicInteger) {
            entryCount.notifyAll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Bundle startBundle(boolean doWait) throws ObjectCreationException {
        try {
            if (this.enterMethod(doWait, this.startBundleEntryCount)) {
                this.configurePropertiesUsingConfigAdmin();
                this.resolveBundle();
                this.processAnnotations(true);
                for (Bundle bundle : this.dependentBundles) {
                    try {
                        if (bundle.getState() == 32 || bundle.getState() == 8) continue;
                        bundle.start();
                    }
                    catch (BundleException e) {
                        if (bundle.getHeaders().get("Fragment-Host") != null) continue;
                        throw e;
                    }
                }
            }
            if (this.osgiBundle.getState() == 32 || this.osgiBundle.getState() == 8) return this.osgiBundle;
            int retry = 0;
            while (retry++ < 10) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws BundleException {
                            OSGiImplementationProvider.this.osgiBundle.start();
                            return null;
                        }
                    });
                    return this.osgiBundle;
                }
                catch (PrivilegedActionException e) {
                    Thread.yield();
                    if (retry != 10) continue;
                    throw e;
                    return this.osgiBundle;
                }
            }
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
        finally {
            this.exitMethod(this.startBundleEntryCount);
        }
    }

    protected ServiceReference getOSGiServiceReference(ComponentService service) throws ObjectCreationException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (!service.isCallback()) {
            this.processProperties(this.implementation.getServiceProperties(service.getName()), props);
        } else {
            this.processProperties(this.implementation.getServiceCallbackProperties(service.getName()), props);
        }
        String filter = this.getOSGiFilter(props);
        Interface serviceInterface = service.getInterfaceContract().getInterface();
        String scaServiceName = service.getName();
        return this.getOSGiServiceReference(serviceInterface, filter, scaServiceName);
    }

    protected ServiceReference getOSGiServiceReference(EndpointReference from, Interface callbackInterface) throws ObjectCreationException {
        RuntimeWire refWire = null;
        String filter = null;
        for (RuntimeWire wire : this.referenceWires.keySet()) {
            if (wire.getSource() != from) continue;
            refWire = wire;
            break;
        }
        if (refWire != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ComponentReference scaRef = this.componentReferenceWires.get(refWire);
            this.processProperties(this.implementation.getReferenceCallbackProperties(scaRef.getName()), props);
            filter = this.getOSGiFilter(props);
        }
        return this.getOSGiServiceReference(callbackInterface, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference getOSGiServiceReference(Interface serviceInterface, String filter, String scaServiceName) throws ObjectCreationException {
        try {
            String serviceInterfaceName = null;
            ServiceReference osgiServiceReference = null;
            if (serviceInterface instanceof JavaInterface && (osgiServiceReference = this.getOSGiServiceReference(scaServiceName, serviceInterfaceName = ((JavaInterface)serviceInterface).getJavaClass().getName(), filter)) == null) {
                OSGiImplementationImpl oSGiImplementationImpl = this.implementation;
                synchronized (oSGiImplementationImpl) {
                    long startTime = System.currentTimeMillis();
                    while ((osgiServiceReference = this.getOSGiServiceReference(scaServiceName, serviceInterfaceName, filter)) == null) {
                        this.implementation.wait(100L);
                        if (System.currentTimeMillis() - startTime <= 300000L) continue;
                    }
                }
            }
            return osgiServiceReference;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    protected Bundle installDummyBundleWithoutFragments(Class<?> interfaceClass) throws Exception {
        String existingClasses;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String EOL = System.getProperty("line.separator");
        String interfaceName = interfaceClass.getName();
        String packageName = OSGiImplementationProvider.getPackageName(interfaceClass);
        String bundleName = "dummy.sca." + packageName;
        String manifestStr = "Manifest-Version: 1.0" + EOL + "Bundle-ManifestVersion: 2" + EOL + "Bundle-Name: " + bundleName + EOL + "Bundle-SymbolicName: " + bundleName + EOL + "Bundle-Version: " + "1.0.0" + EOL + "Bundle-Localization: plugin" + EOL;
        ArrayList<String> dummyClasses = new ArrayList<String>();
        StringBuilder manifestBuf = new StringBuilder();
        manifestBuf.append(manifestStr);
        manifestBuf.append("Export-Package: " + packageName + EOL);
        String exportedInterfaces = interfaceName;
        Bundle existingBundle = this.getDummyHostBundle(packageName);
        dummyClasses.add(interfaceClass.getName());
        for (Class<?> clazz : interfaceClass.getClasses()) {
            dummyClasses.add(clazz.getName());
        }
        if (existingBundle != null && (existingClasses = (String)existingBundle.getHeaders().get("SCA-Dummy-Classes")) != null) {
            exportedInterfaces = exportedInterfaces + " " + existingClasses;
            StringTokenizer tokenizer = new StringTokenizer(existingClasses);
            while (tokenizer.hasMoreTokens()) {
                String className = tokenizer.nextToken();
                if (dummyClasses.contains(className)) continue;
                dummyClasses.add(className);
            }
        }
        manifestBuf.append("SCA-Dummy-Classes: " + exportedInterfaces + EOL);
        ByteArrayInputStream manifestStream = new ByteArrayInputStream(manifestBuf.toString().getBytes());
        Manifest manifest = new Manifest();
        manifest.read(manifestStream);
        JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
        for (int i = 0; i < dummyClasses.size(); ++i) {
            String className = (String)dummyClasses.get(i);
            Class<?> clazz = interfaceClass.getClassLoader().loadClass(className);
            className = clazz.getName().replaceAll("\\.", "/") + ".class";
            ZipEntry ze = new ZipEntry(className);
            jarOut.putNextEntry(ze);
            InputStream stream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            jarOut.write(bytes);
            stream.close();
        }
        jarOut.close();
        out.close();
        if (existingBundle != null) {
            existingBundle.stop();
            existingBundle.uninstall();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Bundle bundle = this.bundleContext.installBundle("file://" + bundleName + ".jar", (InputStream)in);
        bundle.start();
        if (existingBundle != null && this.packageAdmin != null) {
            this.refreshPackages();
        }
        return bundle;
    }

    private Bundle getDummyHostBundle(String packageName) {
        if (this.packageAdmin == null) {
            return null;
        }
        ExportedPackage exp = this.packageAdmin.getExportedPackage(packageName);
        if (exp == null) {
            return null;
        }
        return exp.getExportingBundle();
    }

    private static String getPackageName(Class<?> cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    private Bundle installDummyBundle(Class<?> interfaceClass) throws Exception {
        if (!this.osgiRuntime.supportsBundleFragments()) {
            return this.installDummyBundleWithoutFragments(interfaceClass);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String EOL = System.getProperty("line.separator");
        ArrayList dummyClasses = new ArrayList();
        String interfaceName = interfaceClass.getName();
        String packageName = OSGiImplementationProvider.getPackageName(interfaceClass);
        String bundleName = "dummy.sca." + interfaceName;
        String manifestStr = "Manifest-Version: 1.0" + EOL + "Bundle-ManifestVersion: 2" + EOL + "Bundle-Name: " + bundleName + EOL + "Bundle-SymbolicName: " + bundleName + EOL + "Bundle-Version: " + "1.0.0" + EOL + "Bundle-Localization: plugin" + EOL;
        StringBuilder manifestBuf = new StringBuilder();
        manifestBuf.append(manifestStr);
        manifestBuf.append("Export-Package: " + packageName + EOL);
        Bundle dummyHost = this.getDummyHostBundle(packageName);
        if (dummyHost != null) {
            manifestBuf.append("Fragment-Host: " + dummyHost.getSymbolicName() + EOL);
        }
        ByteArrayInputStream manifestStream = new ByteArrayInputStream(manifestBuf.toString().getBytes());
        Manifest manifest = new Manifest();
        manifest.read(manifestStream);
        dummyClasses.add(interfaceClass);
        for (Class<?> clazz : interfaceClass.getClasses()) {
            dummyClasses.add(clazz);
        }
        JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
        for (int i = 0; i < dummyClasses.size(); ++i) {
            Class clazz = (Class)dummyClasses.get(i);
            String className = clazz.getName();
            className = clazz.getName().replaceAll("\\.", "/") + ".class";
            ZipEntry ze = new ZipEntry(className);
            jarOut.putNextEntry(ze);
            InputStream stream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            jarOut.write(bytes);
            stream.close();
        }
        jarOut.close();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Bundle bundle = this.bundleContext.installBundle("file://" + bundleName + ".jar", (InputStream)in);
        if (dummyHost == null) {
            bundle.start();
        }
        return bundle;
    }

    @Override
    public InstanceWrapper<?> createInstanceWrapper() throws ObjectCreationException {
        return new OSGiInstanceWrapper(this, this.osgiAnnotations, this.bundleContext);
    }

    private void resolveWireCreateDummyBundles(final Class interfaceClass) throws Exception {
        block2: {
            try {
                this.osgiBundle.loadClass(interfaceClass.getName());
            }
            catch (ClassNotFoundException e) {
                Bundle dummyBundle = AccessController.doPrivileged(new PrivilegedExceptionAction<Bundle>(){

                    @Override
                    public Bundle run() throws Exception {
                        return OSGiImplementationProvider.this.installDummyBundle(interfaceClass);
                    }
                });
                if (this.packageAdmin == null) break block2;
                this.packageAdmin.resolveBundles(new Bundle[]{dummyBundle, this.osgiBundle});
            }
        }
    }

    private boolean resolveWireResolveReferences(Bundle bundle, Class interfaceClass, RuntimeWire wire, boolean isOSGiToOSGiWire) throws Exception {
        boolean createProxy = true;
        ComponentReference scaRef = this.componentReferenceWires.get(wire);
        Hashtable<String, Object> targetProperties = new Hashtable<String, Object>();
        this.processProperties(this.implementation.getReferenceProperties(scaRef.getName()), targetProperties);
        if (isOSGiToOSGiWire) {
            Interface interfaze;
            OSGiImplementationProvider implProvider = (OSGiImplementationProvider)wire.getTarget().getComponent().getImplementationProvider();
            isOSGiToOSGiWire = true;
            if (!implProvider.getScope().equals(Scope.COMPOSITE)) {
                createProxy = true;
            }
            if ((interfaze = wire.getTarget().getInterfaceContract().getInterface()).isRemotable()) {
                createProxy = true;
            }
            List<Operation> ops = interfaze.getOperations();
            for (Operation op : ops) {
                if (!op.isNonBlocking()) continue;
                createProxy = true;
            }
            if (targetProperties.size() > 0) {
                createProxy = true;
            }
            if (this.componentProperties.size() > 0) {
                createProxy = true;
            }
            if (!createProxy) {
                implProvider.startBundle(false);
            } else {
                implProvider.resolveBundle();
            }
        } else {
            createProxy = true;
        }
        return createProxy;
    }

    private void resolveWireRegisterProxyService(final Bundle bundle, final Class interfaceClass, RuntimeWire wire) throws Exception {
        ComponentReference scaRef = this.componentReferenceWires.get(wire);
        Hashtable<String, Object> targetProperties = new Hashtable<String, Object>();
        this.processProperties(this.implementation.getReferenceProperties(scaRef.getName()), targetProperties);
        targetProperties.put("service.ranking", Integer.MAX_VALUE);
        if (targetProperties.get(COMPONENT_SERVICE_NAME) == null && wire.getTarget().getComponent() != null) {
            String compServiceName = wire.getTarget().getComponent().getName() + "/" + wire.getTarget().getContract().getName();
            targetProperties.put(COMPONENT_SERVICE_NAME, compServiceName);
        }
        JDKProxyFactory proxyService = new JDKProxyFactory(this.messageFactory, this.mapper);
        final Class proxyInterface = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                return bundle.loadClass(interfaceClass.getName());
            }
        });
        final Object proxy = proxyService.createProxy(proxyInterface, wire);
        final Hashtable<String, Object> finalTargetProperties = targetProperties;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                OSGiImplementationProvider.this.bundleContext.registerService(proxyInterface.getName(), proxy, (Dictionary)finalTargetProperties);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPackages() {
        if (this.packageAdmin != null) {
            OSGiImplementationProvider oSGiImplementationProvider = this;
            synchronized (oSGiImplementationProvider) {
                this.packagesRefreshed = false;
                this.packageAdmin.refreshPackages(null);
                if (!this.packagesRefreshed) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.packagesRefreshed = false;
            }
        }
    }

    private void resolveBundle() throws ObjectCreationException {
        try {
            if (!this.wiresResolved) {
                this.wiresResolved = true;
                if (!this.setReferencesAndProperties()) {
                    this.wiresResolved = false;
                    return;
                }
                int refPlusServices = this.referenceWires.size() + this.runtimeComponent.getServices().size();
                boolean[] createProxyService = new boolean[refPlusServices];
                Class[] interfaceClasses = new Class[refPlusServices];
                boolean[] isOSGiToOSGiWire = new boolean[refPlusServices];
                boolean[] wireResolved = new boolean[refPlusServices];
                int index = 0;
                for (RuntimeWire wire : this.referenceWires.keySet()) {
                    Reference reference = this.referenceWires.get(wire);
                    isOSGiToOSGiWire[index] = wire.getTarget().getComponent() != null && wire.getTarget().getComponent().getImplementationProvider() instanceof OSGiImplementationProvider;
                    Interface refInterface = reference.getInterfaceContract().getInterface();
                    if (refInterface instanceof JavaInterface) {
                        interfaceClasses[index] = ((JavaInterface)refInterface).getJavaClass();
                        if (!isOSGiToOSGiWire[index]) {
                            this.resolveWireCreateDummyBundles(interfaceClasses[index]);
                        }
                    }
                    if (!this.resolvedWires.contains(wire)) {
                        this.resolvedWires.add(wire);
                    } else {
                        wireResolved[index] = true;
                    }
                    ++index;
                }
                for (ComponentService service : this.runtimeComponent.getServices()) {
                    Interface callbackInterface = service.getInterfaceContract().getCallbackInterface();
                    if (callbackInterface instanceof JavaInterface) {
                        interfaceClasses[index] = ((JavaInterface)callbackInterface).getJavaClass();
                        this.resolveWireCreateDummyBundles(interfaceClasses[index]);
                    }
                    ++index;
                }
                index = 0;
                for (RuntimeWire wire : this.referenceWires.keySet()) {
                    if (!wireResolved[index]) {
                        createProxyService[index] = this.resolveWireResolveReferences(this.osgiBundle, interfaceClasses[index], wire, isOSGiToOSGiWire[index]);
                    }
                    ++index;
                }
                this.refreshPackages();
                index = 0;
                for (RuntimeWire wire : this.referenceWires.keySet()) {
                    if (createProxyService[index] && !wireResolved[index]) {
                        this.resolveWireRegisterProxyService(this.osgiBundle, interfaceClasses[index], wire);
                    }
                    ++index;
                }
            } else if (this.osgiBundle.getState() == 2 && this.packageAdmin != null) {
                this.packageAdmin.resolveBundles(new Bundle[]{this.osgiBundle});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ObjectCreationException(e);
        }
    }

    private void configurePropertiesUsingConfigAdmin() {
        try {
            if (this.componentProperties.size() == 0) {
                return;
            }
            ServiceReference configAdminReference = this.bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
            if (configAdminReference != null) {
                Object cm = this.bundleContext.getService(configAdminReference);
                Class<?> cmClass = cm.getClass().getClassLoader().loadClass("org.osgi.service.cm.ConfigurationAdmin");
                Method getConfigMethod = cmClass.getMethod("getConfiguration", String.class, String.class);
                Class<?> configClass = cm.getClass().getClassLoader().loadClass("org.osgi.service.cm.Configuration");
                Method getMethod = configClass.getMethod("getProperties", new Class[0]);
                Method updateMethod = configClass.getMethod("update", Dictionary.class);
                List<Service> services = this.implementation.getServices();
                HashSet pidsProcessed = new HashSet();
                for (Service service : services) {
                    List<ComponentProperty> serviceProps = this.implementation.getServiceProperties(service.getName());
                    String pid = null;
                    if (serviceProps != null) {
                        for (ComponentProperty prop : serviceProps) {
                            if (!prop.getName().equals("service.pid")) continue;
                            ObjectFactory objFactory = this.propertyValueFactory.createValueFactory((Property)prop, prop.getValue(), String.class);
                            pid = (String)objFactory.getInstance();
                        }
                    }
                    if (pid == null || pidsProcessed.contains(pid)) continue;
                    Object config = getConfigMethod.invoke(cm, pid, null);
                    Hashtable<String, Object> props = (Hashtable<String, Object>)getMethod.invoke(config, new Object[0]);
                    if (props == null) {
                        props = new Hashtable<String, Object>();
                    }
                    for (String propertyName : this.componentProperties.keySet()) {
                        ((Dictionary)props).put(propertyName, this.componentProperties.get(propertyName));
                    }
                    updateMethod.invoke(config, props);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isOptimizable() {
        return false;
    }

    @Override
    public Scope getScope() {
        return this.osgiAnnotations.getScope();
    }

    @Override
    public boolean isEagerInit() {
        return this.osgiAnnotations.isEagerInit();
    }

    @Override
    public long getMaxAge() {
        return this.osgiAnnotations.getMaxAge();
    }

    @Override
    public long getMaxIdleTime() {
        return this.osgiAnnotations.getMaxIdleTime();
    }

    protected ScopeContainer<?> getScopeContainer() {
        this.startBundle(true);
        return ((ScopedRuntimeComponent)this.runtimeComponent).getScopeContainer();
    }

    public Invoker createTargetInvoker(RuntimeComponentService service, Operation operation) {
        Interface serviceInterface = operation.getInterface();
        boolean isRemotable = serviceInterface.isRemotable();
        OSGiTargetInvoker invoker = new OSGiTargetInvoker(operation, this, service);
        if (isRemotable) {
            return new OSGiRemotableInvoker(this.osgiAnnotations, this.dataBindingRegistry, operation, this, service);
        }
        return invoker;
    }

    @Override
    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        return this.createTargetInvoker(service, operation);
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    private boolean setReferencesAndProperties() {
        for (Reference ref : this.implementation.getReferences()) {
            List<RuntimeWire> wireList = null;
            ComponentReference compRef = null;
            for (ComponentReference cRef : this.runtimeComponent.getReferences()) {
                if (!cRef.getName().equals(ref.getName())) continue;
                wireList = ((RuntimeComponentReference)cRef).getRuntimeWires();
                compRef = cRef;
                break;
            }
            if (ref.getMultiplicity() == Multiplicity.ONE_N || ref.getMultiplicity() == Multiplicity.ZERO_N) {
                for (RuntimeWire wire : wireList) {
                    this.referenceWires.put(wire, ref);
                    this.componentReferenceWires.put(wire, compRef);
                }
                continue;
            }
            if (wireList == null && ref.getMultiplicity() == Multiplicity.ONE_ONE) {
                throw new IllegalStateException("Required reference is missing: " + ref.getName());
            }
            if (wireList == null || wireList.isEmpty()) continue;
            RuntimeWire wire = wireList.get(0);
            this.referenceWires.put(wire, ref);
            this.componentReferenceWires.put(wire, compRef);
        }
        this.processProperties(this.runtimeComponent.getProperties(), this.componentProperties);
        return true;
    }

    @Override
    public void start() {
        this.setReferencesAndProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(boolean doWait) throws IntrospectionException {
        if (!this.enterMethod(doWait, this.processAnnotationsEntryCount)) {
            return;
        }
        try {
            this.osgiAnnotations.processAnnotations();
            Scope scope = this.osgiAnnotations.getScope();
            if (!scope.equals(Scope.SYSTEM)) {
                if (scope.equals(Scope.COMPOSITE)) {
                } else if (this.runtimeComponent instanceof ScopedRuntimeComponent) {
                    ScopedRuntimeComponent component = (ScopedRuntimeComponent)this.runtimeComponent;
                    ScopeContainer oldScopeContainer = component.getScopeContainer();
                    component.setScopeContainer(null);
                    ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(this.runtimeComponent);
                    if (oldScopeContainer != null && oldScopeContainer.getLifecycleState() == 4) {
                        scopeContainer.start();
                    }
                    component.setScopeContainer(scopeContainer);
                }
            }
        }
        finally {
            this.exitMethod(this.processAnnotationsEntryCount);
        }
    }

    @Override
    public void stop() {
        if (this.osgiServiceListener != null) {
            this.bundleContext.removeServiceListener((ServiceListener)this.osgiServiceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            OSGiImplementationProvider oSGiImplementationProvider = this;
            synchronized (oSGiImplementationProvider) {
                this.packagesRefreshed = true;
                this.notifyAll();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32 && event.getBundle() == this.osgiBundle) {
            try {
                this.processAnnotations(false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class OSGiServiceListener
    implements ServiceListener {
        private Bundle bundle;

        OSGiServiceListener(Bundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            ServiceReference reference = event.getServiceReference();
            if (event.getType() == 1 && reference.getBundle() == this.bundle) {
                OSGiImplementationImpl oSGiImplementationImpl = OSGiImplementationProvider.this.implementation;
                synchronized (oSGiImplementationImpl) {
                    OSGiImplementationProvider.this.implementation.notifyAll();
                }
            }
            if (event.getType() != 4 || reference.getBundle() == this.bundle) {
                // empty if block
            }
        }
    }
}

