/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.runtime;

import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.osgi.OSGiImplementation;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiImplementationProvider;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiImplementationProviderFactory
implements ImplementationProviderFactory<OSGiImplementation> {
    private DataBindingExtensionPoint dataBindings;
    private JavaPropertyValueObjectFactory propertyFactory;
    private ProxyFactory proxyFactory;
    private ScopeRegistry scopeRegistry;
    private MessageFactory messageFactory;
    private InterfaceContractMapper mapper;
    private RequestContextFactory requestContextFactory;

    public OSGiImplementationProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.dataBindings = extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        ProxyFactoryExtensionPoint proxyFactories = extensionPoints.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        this.proxyFactory = new ExtensibleProxyFactory(proxyFactories);
        ContextFactoryExtensionPoint contextFactories = extensionPoints.getExtensionPoint(ContextFactoryExtensionPoint.class);
        this.requestContextFactory = contextFactories.getFactory(RequestContextFactory.class);
        this.scopeRegistry = extensionPoints.getExtensionPoint(ScopeRegistry.class);
        Mediator mediator = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
        this.propertyFactory = new JavaPropertyValueObjectFactory(mediator);
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.mapper = utilities.getUtility(InterfaceContractMapper.class);
    }

    @Override
    public ImplementationProvider createImplementationProvider(RuntimeComponent component, OSGiImplementation implementation) {
        try {
            return new OSGiImplementationProvider(component, implementation, this.dataBindings, this.propertyFactory, this.proxyFactory, this.scopeRegistry, this.requestContextFactory, this.messageFactory, this.mapper);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<OSGiImplementation> getModelType() {
        return OSGiImplementation.class;
    }
}

