/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.osgi.BundleReference;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.implementation.osgi.impl.OSGiImplementationImpl;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiImplementationProcessor
implements StAXArtifactProcessor<OSGiImplementationImpl> {
    public static final QName IMPLEMENTATION_OSGI = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.osgi");
    private static final String BUNDLE_SYMBOLICNAME = "bundleSymbolicName";
    private static final String BUNDLE_VERSION = "bundleVersion";
    private static final String CLASSES = "classes";
    private static final String IMPORTS = "imports";
    private static final QName PROPERTIES_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "properties");
    private static final QName PROPERTY_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "property");
    private JavaInterfaceFactory javaInterfaceFactory;
    private AssemblyFactory assemblyFactory;
    private ModelFactoryExtensionPoint modelFactories;
    private Monitor monitor;
    private static final DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();

    public OSGiImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
        this.modelFactories = modelFactories;
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-osgi-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-osgi-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_OSGI;
    }

    @Override
    public Class<OSGiImplementationImpl> getModelType() {
        return OSGiImplementationImpl.class;
    }

    private String[] tokenize(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str);
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }

    @Override
    public OSGiImplementationImpl read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        int next;
        assert (IMPLEMENTATION_OSGI.equals(reader.getName()));
        String bundleSymbolicName = reader.getAttributeValue(null, BUNDLE_SYMBOLICNAME);
        String bundleVersion = reader.getAttributeValue(null, BUNDLE_VERSION);
        String imports = reader.getAttributeValue(null, IMPORTS);
        String[] importList = imports != null ? this.tokenize(imports) : new String[]{};
        String classes = reader.getAttributeValue(null, CLASSES);
        String[] classList = classes != null ? this.tokenize(classes) : new String[]{};
        Hashtable<String, List<ComponentProperty>> refProperties = new Hashtable<String, List<ComponentProperty>>();
        Hashtable<String, List<ComponentProperty>> serviceProperties = new Hashtable<String, List<ComponentProperty>>();
        Hashtable<String, List<ComponentProperty>> refCallbackProperties = new Hashtable<String, List<ComponentProperty>>();
        Hashtable<String, List<ComponentProperty>> serviceCallbackProperties = new Hashtable<String, List<ComponentProperty>>();
        while (reader.hasNext() && ((next = reader.next()) != 2 || !IMPLEMENTATION_OSGI.equals(reader.getName()))) {
            if (next != 1 || !PROPERTIES_QNAME.equals(reader.getName())) continue;
            String refName = reader.getAttributeValue(null, "reference");
            String serviceName = reader.getAttributeValue(null, "service");
            String refCallbackName = reader.getAttributeValue(null, "referenceCallback");
            String serviceCallbackName = reader.getAttributeValue(null, "serviceCallback");
            List<ComponentProperty> props = this.readProperties(reader);
            if (refName != null) {
                refProperties.put(refName, props);
                continue;
            }
            if (serviceName != null) {
                serviceProperties.put(serviceName, props);
                continue;
            }
            if (refCallbackName != null) {
                refCallbackProperties.put(refCallbackName, props);
                continue;
            }
            if (serviceCallbackName != null) {
                serviceCallbackProperties.put(serviceCallbackName, props);
                continue;
            }
            this.error("PropertyShouldSpecifySR", (Object)reader, new Object[0]);
        }
        OSGiImplementationImpl implementation = new OSGiImplementationImpl(this.modelFactories, bundleSymbolicName, bundleVersion, importList, classList, refProperties, serviceProperties);
        implementation.setCallbackProperties(refCallbackProperties, serviceCallbackProperties);
        implementation.setUnresolved(true);
        return implementation;
    }

    @Override
    public void resolve(OSGiImplementationImpl impl, ModelResolver resolver) throws ContributionResolveException {
        try {
            if (impl == null || !impl.isUnresolved()) {
                return;
            }
            impl.setUnresolved(false);
            BundleReference bundleReference = new BundleReference(impl.getBundleSymbolicName(), impl.getBundleVersion());
            BundleReference resolvedBundle = resolver.resolveModel(BundleReference.class, bundleReference);
            Bundle bundle = (Bundle)resolvedBundle.getBundle();
            if (bundle == null) {
                this.error("CouldNotLocateOSGiBundle", (Object)impl, impl.getBundleSymbolicName());
                return;
            }
            impl.setOSGiBundle(bundle);
            String bundleName = resolvedBundle.getBundleRelativePath();
            String ctURI = bundleName.endsWith(".jar") || bundleName.endsWith(".JAR") ? bundleName.substring(0, bundleName.lastIndexOf(".")) : bundleName;
            ctURI = ctURI.replaceAll("\\.", "/");
            ctURI = ctURI + ".componentType";
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(ctURI);
            componentType.setUnresolved(true);
            componentType = resolver.resolveModel(ComponentType.class, componentType);
            if (componentType.isUnresolved()) {
                this.error("MissingComponentTypeFile", (Object)impl, ctURI);
                return;
            }
            List<Service> services = componentType.getServices();
            for (Service service : services) {
                Interface interfaze = service.getInterfaceContract().getInterface();
                if (!(interfaze instanceof JavaInterface)) continue;
                JavaInterface javaInterface = (JavaInterface)interfaze;
                if (javaInterface.getJavaClass() == null) {
                    javaInterface.setJavaClass(this.getJavaClass(resolver, javaInterface.getName()));
                }
                Class<?> callback = null;
                if (service.getInterfaceContract().getCallbackInterface() instanceof JavaInterface) {
                    JavaInterface callbackInterface = (JavaInterface)service.getInterfaceContract().getCallbackInterface();
                    if (callbackInterface.getJavaClass() == null) {
                        callbackInterface.setJavaClass(this.getJavaClass(resolver, callbackInterface.getName()));
                    }
                    callback = callbackInterface.getJavaClass();
                }
                Service serv = this.createService(service, javaInterface.getJavaClass(), callback);
                impl.getServices().add(serv);
            }
            List<Reference> references = componentType.getReferences();
            for (Reference reference : references) {
                Interface interfaze = reference.getInterfaceContract().getInterface();
                if (interfaze instanceof JavaInterface) {
                    JavaInterface javaInterface = (JavaInterface)interfaze;
                    if (javaInterface.getJavaClass() == null) {
                        javaInterface.setJavaClass(this.getJavaClass(resolver, javaInterface.getName()));
                    }
                    Reference ref = this.createReference(reference, javaInterface.getJavaClass());
                    impl.getReferences().add(ref);
                    continue;
                }
                impl.getReferences().add(reference);
            }
            List<Property> properties = componentType.getProperties();
            for (Property property : properties) {
                impl.getProperties().add(property);
            }
            impl.setConstrainingType(componentType.getConstrainingType());
        }
        catch (InvalidInterfaceException e) {
            ContributionResolveException ce = new ContributionResolveException(e);
            this.error("ContributionResolveException", (Object)resolver, ce);
        }
    }

    private Class getJavaClass(ModelResolver resolver, String className) {
        ClassReference ref = new ClassReference(className);
        ref = resolver.resolveModel(ClassReference.class, ref);
        return ref.getJavaClass();
    }

    private Service createService(Service serv, Class<?> interfaze, Class<?> callbackInterfaze) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(serv.getName());
        JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callbackInterfaze != null) {
            JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callbackInterfaze);
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        } else if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return service;
    }

    private Reference createReference(Reference ref, Class<?> clazz) throws InvalidInterfaceException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        reference.setName(ref.getName());
        reference.setMultiplicity(ref.getMultiplicity());
        JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(clazz);
        reference.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass());
            reference.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return reference;
    }

    @Override
    public void write(OSGiImplementationImpl model, XMLStreamWriter outputSource) throws ContributionWriteException, XMLStreamException {
    }

    private QName getQNameValue(XMLStreamReader reader, String value) {
        if (value != null) {
            int index = value.indexOf(58);
            String prefix = index == -1 ? "" : value.substring(0, index);
            String localName = index == -1 ? value : value.substring(index + 1);
            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, localName, prefix);
        }
        return null;
    }

    private void declareNamespace(Element element, String prefix, String ns) {
        NamedNodeMap attrs;
        String qname = null;
        qname = "".equals(prefix) ? "xmlns" : "xmlns:" + prefix;
        boolean declared = false;
        for (Node node = element; node != null && node.getNodeType() == 1 && (attrs = node.getAttributes()) != null; node = node.getParentNode()) {
            Node attr = attrs.getNamedItem(qname);
            if (attr == null) continue;
            declared = ns.equals(attr.getNodeValue());
            break;
        }
        if (!declared) {
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(ns);
            element.setAttributeNodeNS(attr);
        }
    }

    private Element createElement(Document document, QName name) {
        String prefix = name.getPrefix();
        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + name.getLocalPart() : name.getLocalPart();
        return document.createElementNS(name.getNamespaceURI(), qname);
    }

    private void loadElement(XMLStreamReader reader, Element root) throws XMLStreamException {
        Document document = root.getOwnerDocument();
        Node current = root;
        block6: while (true) {
            switch (reader.next()) {
                case 1: {
                    int i;
                    QName name = reader.getName();
                    Element child = this.createElement(document, name);
                    current.appendChild(child);
                    current = child;
                    this.declareNamespace(child, name.getPrefix(), name.getNamespaceURI());
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        this.declareNamespace(child, prefix, ns);
                    }
                    count = reader.getAttributeCount();
                    i = 0;
                    while (true) {
                        if (i >= count) continue block6;
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String localPart = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        child.setAttributeNS(ns, localPart, value);
                        this.declareNamespace(child, prefix, ns);
                        ++i;
                    }
                }
                case 12: {
                    current.appendChild(document.createCDATASection(reader.getText()));
                    break;
                }
                case 4: {
                    current.appendChild(document.createTextNode(reader.getText()));
                    break;
                }
                case 2: {
                    if (current == root) {
                        return;
                    }
                    current = current.getParentNode();
                }
            }
        }
    }

    private Document readPropertyValue(XMLStreamReader reader, QName type) throws XMLStreamException, ParserConfigurationException {
        Document doc = domFactory.newDocumentBuilder().newDocument();
        Element root = doc.createElementNS(null, "value");
        if (type != null) {
            Attr xsi = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi");
            xsi.setValue("http://www.w3.org/2001/XMLSchema-instance");
            root.setAttributeNodeNS(xsi);
            String prefix = type.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "ns";
            }
            this.declareNamespace(root, prefix, type.getNamespaceURI());
            Attr xsiType = doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type");
            xsiType.setValue(prefix + ":" + type.getLocalPart());
            root.setAttributeNodeNS(xsiType);
        }
        doc.appendChild(root);
        this.loadElement(reader, root);
        return doc;
    }

    private void readProperty(ComponentProperty prop, XMLStreamReader reader) throws XMLStreamException, ContributionReadException {
        prop.setName(reader.getAttributeValue(null, "name"));
        String xsdType = reader.getAttributeValue(null, "type");
        if (xsdType != null) {
            prop.setXSDType(this.getQNameValue(reader, xsdType));
        } else {
            prop.setXSDType(SimpleTypeMapperImpl.XSD_STRING);
        }
        try {
            Document value = this.readPropertyValue(reader, prop.getXSDType());
            prop.setValue(value);
        }
        catch (ParserConfigurationException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)reader, ce);
            throw ce;
        }
    }

    private List<ComponentProperty> readProperties(XMLStreamReader reader) throws XMLStreamException, ContributionReadException {
        int next;
        ArrayList<ComponentProperty> properties = new ArrayList<ComponentProperty>();
        while (reader.hasNext() && ((next = reader.next()) != 2 || !PROPERTIES_QNAME.equals(reader.getName()))) {
            if (next != 1 || !PROPERTY_QNAME.equals(reader.getName())) continue;
            ComponentProperty componentProperty = this.assemblyFactory.createComponentProperty();
            this.readProperty(componentProperty, reader);
            properties.add(componentProperty);
        }
        return properties;
    }

    static {
        domFactory.setNamespaceAware(true);
    }
}

