/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.resource.impl;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.resource.Resource;
import org.apache.tuscany.sca.implementation.resource.ResourceImplementation;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceImplementationImpl
implements ResourceImplementation {
    private Service resourceService;
    private String location;
    private URL url;
    private boolean unresolved;

    ResourceImplementationImpl(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        JavaInterface javaInterface;
        this.resourceService = assemblyFactory.createService();
        this.resourceService.setName("Resource");
        try {
            javaInterface = javaFactory.createJavaInterface(Resource.class);
        }
        catch (InvalidInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        JavaInterfaceContract interfaceContract = javaFactory.createJavaInterfaceContract();
        interfaceContract.setInterface(javaInterface);
        this.resourceService.setInterfaceContract(interfaceContract);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public URL getLocationURL() {
        return this.url;
    }

    @Override
    public void setLocationURL(URL url) {
        this.url = url;
    }

    @Override
    public ConstrainingType getConstrainingType() {
        return null;
    }

    @Override
    public List<Property> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public List<Service> getServices() {
        return Collections.singletonList(this.resourceService);
    }

    @Override
    public List<Reference> getReferences() {
        return Collections.emptyList();
    }

    @Override
    public String getURI() {
        return this.location;
    }

    @Override
    public void setConstrainingType(ConstrainingType constrainingType) {
    }

    @Override
    public void setURI(String uri) {
        this.location = uri;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }
}

