/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.introspect;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.implementation.java.DefaultJavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ComponentNameProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ConstructorProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ContextProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DestroyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.EagerInitProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InitProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.PolicyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.PropertyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ReferenceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ResourceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ServiceProcessor;
import org.apache.tuscany.sca.implementation.spring.SpringConstructorArgElement;
import org.apache.tuscany.sca.implementation.spring.introspect.SpringBeanPojoProcessor;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanIntrospector {
    private JavaImplementationFactory javaImplementationFactory = new DefaultJavaImplementationFactory();

    public SpringBeanIntrospector(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory, PolicyFactory policyFactory, List<SpringConstructorArgElement> conArgs) {
        BaseJavaClassVisitor[] extensions;
        for (BaseJavaClassVisitor extension : extensions = new BaseJavaClassVisitor[]{new ConstructorProcessor(assemblyFactory), new ComponentNameProcessor(assemblyFactory), new ContextProcessor(assemblyFactory), new DestroyProcessor(assemblyFactory), new EagerInitProcessor(assemblyFactory), new InitProcessor(assemblyFactory), new PropertyProcessor(assemblyFactory), new ReferenceProcessor(assemblyFactory, javaFactory), new ResourceProcessor(assemblyFactory), new ServiceProcessor(assemblyFactory, javaFactory), new SpringBeanPojoProcessor(assemblyFactory, javaFactory, conArgs), new PolicyProcessor(assemblyFactory, policyFactory)}) {
            this.javaImplementationFactory.addClassVisitor(extension);
        }
    }

    public JavaImplementation introspectBean(Class<?> beanClass, ComponentType componentType) throws ContributionResolveException {
        if (componentType == null) {
            throw new ContributionResolveException("Introspect Spring bean: supplied componentType is null");
        }
        JavaImplementation javaImplementation = this.javaImplementationFactory.createJavaImplementation();
        try {
            this.javaImplementationFactory.createJavaImplementation(javaImplementation, beanClass);
            componentType.getServices().addAll(javaImplementation.getServices());
            componentType.getReferences().addAll(javaImplementation.getReferences());
            componentType.getProperties().addAll(javaImplementation.getProperties());
        }
        catch (IntrospectionException e) {
            throw new ContributionResolveException(e);
        }
        return javaImplementation;
    }
}

