/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.introspect;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.spring.SpringBeanElement;
import org.apache.tuscany.sca.implementation.spring.SpringConstructorArgElement;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.SpringImplementationConstants;
import org.apache.tuscany.sca.implementation.spring.SpringPropertyElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAPropertyElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAReferenceElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAServiceElement;
import org.apache.tuscany.sca.implementation.spring.introspect.SpringBeanIntrospector;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringXMLComponentTypeLoader {
    private XMLInputFactory xmlInputFactory;
    private ContributionFactory contributionFactory;
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaFactory;
    private PolicyFactory policyFactory;
    private SpringBeanIntrospector beanIntrospector;

    public SpringXMLComponentTypeLoader(ModelFactoryExtensionPoint factories, AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory, PolicyFactory policyFactory) {
        this.assemblyFactory = assemblyFactory;
        this.javaFactory = javaFactory;
        this.policyFactory = policyFactory;
        this.contributionFactory = factories.getFactory(ContributionFactory.class);
        this.xmlInputFactory = factories.getFactory(XMLInputFactory.class);
    }

    protected Class<SpringImplementation> getImplementationClass() {
        return SpringImplementation.class;
    }

    public void load(SpringImplementation implementation, ModelResolver resolver) throws ContributionReadException {
        ComponentType componentType = implementation.getComponentType();
        if (componentType == null) {
            throw new ContributionReadException("SpringXMLLoader load: implementation has no ComponentType object");
        }
        if (componentType.isUnresolved()) {
            this.loadFromXML(implementation, resolver);
            if (!componentType.isUnresolved()) {
                implementation.setUnresolved(false);
            }
        }
    }

    private Class<?> resolveClass(ModelResolver resolver, String className) throws ClassNotFoundException {
        ClassReference classReference = new ClassReference(className);
        if ((classReference = resolver.resolveModel(ClassReference.class, classReference)).isUnresolved()) {
            throw new ClassNotFoundException(className);
        }
        Class<?> javaClass = classReference.getJavaClass();
        return javaClass;
    }

    private void loadFromXML(SpringImplementation implementation, ModelResolver resolver) throws ContributionReadException {
        ArrayList<SpringBeanElement> beans = new ArrayList<SpringBeanElement>();
        ArrayList<SpringSCAServiceElement> services = new ArrayList<SpringSCAServiceElement>();
        ArrayList<SpringSCAReferenceElement> references = new ArrayList<SpringSCAReferenceElement>();
        ArrayList<SpringSCAPropertyElement> scaproperties = new ArrayList<SpringSCAPropertyElement>();
        ArrayList<URL> contextResources = new ArrayList();
        String contextPath = implementation.getLocation();
        try {
            URL resource = this.resolveLocation(resolver, contextPath);
            contextResources = this.getApplicationContextResource(resource);
            implementation.setClassLoader(new ContextClassLoader(resolver));
            implementation.setResource(contextResources);
            implementation.setURI(resource.toString());
            for (URL contextResource : contextResources) {
                XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(contextResource.openStream());
                this.readContextDefinition(resolver, reader, contextPath, beans, services, references, scaproperties);
                reader.close();
            }
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException(e);
        }
        this.generateComponentType(implementation, resolver, beans, services, references, scaproperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL resolveLocation(ModelResolver resolver, String contextPath) throws MalformedURLException, ContributionReadException {
        URL resource = null;
        URI uri = URI.create(contextPath);
        if (uri.isAbsolute()) return new URL(contextPath);
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setUnresolved(true);
        artifact.setURI(contextPath);
        artifact = resolver.resolveModel(Artifact.class, artifact);
        if (artifact.isUnresolved()) throw new ContributionReadException("Location cannot be resloved: " + contextPath);
        return new URL(artifact.getLocation());
    }

    private XMLStreamReader getApplicationContextReader(ModelResolver resolver, String location) throws ContributionReadException {
        try {
            URL resource = this.getApplicationContextResource(this.resolveLocation(resolver, location)).get(0);
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(resource.openStream());
            return reader;
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException(e);
        }
    }

    private void readContextDefinition(ModelResolver resolver, XMLStreamReader reader, String contextPath, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) throws ContributionReadException {
        SpringBeanElement bean = null;
        try {
            boolean completed = false;
            block6: while (!completed) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (SpringImplementationConstants.IMPORT_ELEMENT.equals(qname)) {
                            String location = reader.getAttributeValue(null, "resource");
                            if (location == null) continue block6;
                            String resourcePath = contextPath.substring(0, contextPath.lastIndexOf("/") + 1) + location;
                            XMLStreamReader ireader = this.getApplicationContextReader(resolver, resourcePath);
                            this.readContextDefinition(resolver, ireader, contextPath, beans, services, references, scaproperties);
                            break;
                        }
                        if (SpringImplementationConstants.SERVICE_ELEMENT.equals(qname)) {
                            SpringSCAServiceElement service = new SpringSCAServiceElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"), reader.getAttributeValue(null, "target"));
                            services.add(service);
                            break;
                        }
                        if (SpringImplementationConstants.REFERENCE_ELEMENT.equals(qname)) {
                            SpringSCAReferenceElement reference = new SpringSCAReferenceElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"));
                            references.add(reference);
                            break;
                        }
                        if (SpringImplementationConstants.SCAPROPERTY_ELEMENT.equals(qname)) {
                            SpringSCAPropertyElement scaproperty = new SpringSCAPropertyElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "type"));
                            scaproperties.add(scaproperty);
                            break;
                        }
                        if (!SpringImplementationConstants.BEAN_ELEMENT.equals(qname)) break;
                        bean = new SpringBeanElement(reader.getAttributeValue(null, "id"), reader.getAttributeValue(null, "class"));
                        beans.add(bean);
                        this.readBeanDefinition(resolver, reader, contextPath, bean, beans, services, references, scaproperties);
                        break;
                    }
                    case 2: {
                        if (!SpringImplementationConstants.BEANS_ELEMENT.equals(reader.getName())) break;
                        completed = true;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException(e);
        }
    }

    private void readBeanDefinition(ModelResolver resolver, XMLStreamReader reader, String contextPath, SpringBeanElement bean, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) throws ContributionReadException {
        SpringBeanElement innerbean = null;
        SpringPropertyElement property = null;
        SpringConstructorArgElement constructorArg = null;
        int autoConstructorIndex = -1;
        try {
            boolean completed = false;
            block6: while (!completed) {
                switch (reader.next()) {
                    case 1: {
                        String value;
                        QName qname = reader.getName();
                        if (SpringImplementationConstants.BEAN_ELEMENT.equals(qname)) {
                            innerbean = new SpringBeanElement(reader.getAttributeValue(null, "id"), reader.getAttributeValue(null, "class"));
                            innerbean.setInnerBean(true);
                            beans.add(innerbean);
                            this.readBeanDefinition(resolver, reader, contextPath, innerbean, beans, services, references, scaproperties);
                            break;
                        }
                        if (SpringImplementationConstants.PROPERTY_ELEMENT.equals(qname)) {
                            property = new SpringPropertyElement(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, "ref"));
                            bean.addProperty(property);
                            break;
                        }
                        if (SpringImplementationConstants.CONSTRUCTORARG_ELEMENT.equals(qname)) {
                            constructorArg = new SpringConstructorArgElement(reader.getAttributeValue(null, "ref"), reader.getAttributeValue(null, "type"));
                            constructorArg.setAutoIndex(++autoConstructorIndex);
                            if (reader.getAttributeValue(null, "index") != null) {
                                constructorArg.setIndex(new Integer(reader.getAttributeValue(null, "index")));
                            }
                            if (reader.getAttributeValue(null, "value") != null) {
                                value = reader.getAttributeValue(null, "value");
                                constructorArg.addValue(value);
                            }
                            bean.addCustructorArgs(constructorArg);
                            break;
                        }
                        if (SpringImplementationConstants.REF_ELEMENT.equals(qname)) {
                            String ref = reader.getAttributeValue(null, "bean");
                            if (property != null) {
                                property.setRef(ref);
                            }
                            if (constructorArg == null) continue block6;
                            constructorArg.setRef(ref);
                            break;
                        }
                        if (!SpringImplementationConstants.VALUE_ELEMENT.equals(qname)) break;
                        value = reader.getElementText();
                        if (constructorArg == null) continue block6;
                        constructorArg.addValue(value);
                        break;
                    }
                    case 2: {
                        if (SpringImplementationConstants.BEAN_ELEMENT.equals(reader.getName())) {
                            completed = true;
                            break;
                        }
                        if (SpringImplementationConstants.PROPERTY_ELEMENT.equals(reader.getName())) {
                            property = null;
                            break;
                        }
                        if (!SpringImplementationConstants.CONSTRUCTORARG_ELEMENT.equals(reader.getName())) break;
                        constructorArg = null;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException(e);
        }
    }

    private void generateComponentType(SpringImplementation implementation, ModelResolver resolver, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) throws ContributionReadException {
        JavaImplementation javaImplementation = null;
        ComponentType componentType = implementation.getComponentType();
        try {
            ComponentType beanComponentType;
            Class<?> beanClass;
            for (SpringSCAServiceElement serviceElement : services) {
                Class<?> interfaze = this.resolveClass(resolver, serviceElement.getType());
                Service theService = this.createService(interfaze, serviceElement.getName());
                Service duplicate = null;
                for (Service service : componentType.getServices()) {
                    if (!service.getName().equals(theService.getName())) continue;
                    duplicate = service;
                }
                if (duplicate != null) {
                    componentType.getServices().remove(duplicate);
                }
                componentType.getServices().add(theService);
                String beanName = serviceElement.getTarget();
                for (SpringBeanElement beanElement : beans) {
                    if (!beanName.equals(beanElement.getId())) continue;
                    implementation.setBeanForService(theService, beanElement);
                }
            }
            for (SpringSCAReferenceElement referenceElement : references) {
                Class<?> interfaze = this.resolveClass(resolver, referenceElement.getType());
                Reference theReference = this.createReference(interfaze, referenceElement.getName());
                Reference duplicate = null;
                for (Reference reference : componentType.getReferences()) {
                    if (!reference.getName().equals(theReference.getName())) continue;
                    duplicate = reference;
                }
                if (duplicate != null) {
                    componentType.getReferences().remove(duplicate);
                }
                componentType.getReferences().add(theReference);
            }
            for (SpringSCAPropertyElement scaproperty : scaproperties) {
                if (scaproperty.getType() == null || scaproperty.getName() == null) continue;
                Property theProperty = this.assemblyFactory.createProperty();
                theProperty.setName(scaproperty.getName());
                Class<?> propType = Class.forName(scaproperty.getType());
                theProperty.setXSDType(JavaXMLMapper.getXMLType(propType));
                Property duplicate = null;
                for (Property property : componentType.getProperties()) {
                    if (!property.getName().equals(theProperty.getName())) continue;
                    duplicate = property;
                }
                if (duplicate != null) {
                    componentType.getProperties().remove(duplicate);
                }
                componentType.getProperties().add(theProperty);
                implementation.setPropertyClass(theProperty.getName(), propType);
            }
            if (services.isEmpty()) {
                for (SpringBeanElement beanElement : beans) {
                    if (beanElement.isInnerBean()) continue;
                    beanClass = this.resolveClass(resolver, beanElement.getClassName());
                    this.beanIntrospector = new SpringBeanIntrospector(this.assemblyFactory, this.javaFactory, this.policyFactory, beanElement.getCustructorArgs());
                    beanComponentType = this.assemblyFactory.createComponentType();
                    javaImplementation = this.beanIntrospector.introspectBean(beanClass, beanComponentType);
                    for (Service componentService : beanComponentType.getServices()) {
                        componentService.setName(beanElement.getId());
                    }
                    List<Service> beanServices = beanComponentType.getServices();
                    componentType.getServices().addAll(beanServices);
                    for (Service beanService : beanServices) {
                        implementation.setBeanForService(beanService, beanElement);
                    }
                }
            }
            for (SpringBeanElement beanElement : beans) {
                if (beanElement.getProperties().isEmpty() && beanElement.getCustructorArgs().isEmpty()) continue;
                beanClass = this.resolveClass(resolver, beanElement.getClassName());
                this.beanIntrospector = new SpringBeanIntrospector(this.assemblyFactory, this.javaFactory, this.policyFactory, beanElement.getCustructorArgs());
                beanComponentType = this.assemblyFactory.createComponentType();
                javaImplementation = this.beanIntrospector.introspectBean(beanClass, beanComponentType);
                Map<String, JavaElementImpl> propertyMap = javaImplementation.getPropertyMembers();
                JavaConstructorImpl<?> constructor = javaImplementation.getConstructor();
                List<Reference> beanReferences = beanComponentType.getReferences();
                List<Property> beanProperties = beanComponentType.getProperties();
                for (SpringPropertyElement propertyElement : beanElement.getProperties()) {
                    if (!this.propertyRefUnresolved(propertyElement.getRef(), beans, references, scaproperties)) continue;
                    for (Reference reference : beanReferences) {
                        if (!propertyElement.getName().equals(reference.getName())) continue;
                        reference.setName(propertyElement.getRef());
                        componentType.getReferences().add(reference);
                    }
                    for (Property scaproperty : beanProperties) {
                        if (!propertyElement.getName().equals(scaproperty.getName())) continue;
                        Class<?> interfaze = this.resolveClass(resolver, propertyMap.get(propertyElement.getName()).getType().getName());
                        Reference theReference = this.createReference(interfaze, propertyElement.getRef());
                        implementation.setUnresolvedBeanRef(propertyElement.getRef(), theReference);
                    }
                }
                for (SpringConstructorArgElement conArgElement : beanElement.getCustructorArgs()) {
                    if (!this.propertyRefUnresolved(conArgElement.getRef(), beans, references, scaproperties)) continue;
                    for (JavaParameterImpl parameter : constructor.getParameters()) {
                        Reference theReference;
                        String paramType = parameter.getType().getName();
                        Class<?> interfaze = this.resolveClass(resolver, paramType);
                        if ((conArgElement.getType() == null || !paramType.equals(conArgElement.getType())) && (conArgElement.getIndex() == -1 || conArgElement.getIndex() != parameter.getIndex())) continue;
                        if (parameter.getClassifer().getName().equals("org.osoa.sca.annotations.Reference")) {
                            theReference = this.createReference(interfaze, conArgElement.getRef());
                            componentType.getReferences().add(theReference);
                        }
                        if (!parameter.getClassifer().getName().equals("org.osoa.sca.annotations.Property")) continue;
                        theReference = this.createReference(interfaze, conArgElement.getRef());
                        implementation.setUnresolvedBeanRef(conArgElement.getRef(), theReference);
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new ContributionReadException(e);
        }
        catch (InvalidInterfaceException e) {
            throw new ContributionReadException(e);
        }
        catch (ContributionResolveException e) {
            // empty catch block
        }
        componentType.setUnresolved(false);
        implementation.setComponentType(componentType);
    }

    private boolean propertyRefUnresolved(String ref, List<SpringBeanElement> beans, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) {
        boolean unresolved = true;
        if (ref != null) {
            for (SpringBeanElement beanElement : beans) {
                if (!ref.equals(beanElement.getId())) continue;
                unresolved = false;
                break;
            }
            if (unresolved) {
                for (SpringSCAReferenceElement referenceElement : references) {
                    if (!ref.equals(referenceElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
            if (unresolved) {
                for (SpringSCAPropertyElement propertyElement : scaproperties) {
                    if (!ref.equals(propertyElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
        } else {
            unresolved = false;
        }
        return unresolved;
    }

    protected List<URL> getApplicationContextResource(URL url) throws ContributionReadException {
        block20: {
            File manifestFile = null;
            File locationFile = null;
            ArrayList<URL> appCtxResources = new ArrayList<URL>();
            if (url == null) {
                throw new ContributionReadException("SpringXMLComponentTypeLoader getApplicationContextResource: unable to find resource file " + url);
            }
            String path = url.getPath();
            locationFile = new File(path);
            if (locationFile.isDirectory()) {
                try {
                    Manifest mf;
                    Attributes mainAttrs;
                    String appCtxPath;
                    manifestFile = new File(locationFile, "META-INF" + File.separator + "MANIFEST.MF");
                    if (manifestFile.exists() && (appCtxPath = (mainAttrs = (mf = new Manifest(new FileInputStream(manifestFile))).getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path2 : cxtPaths = appCtxPath.split(";")) {
                            File appXmlFile = new File(locationFile, path2);
                            if (!appXmlFile.exists()) continue;
                            appCtxResources.add(appXmlFile.toURI().toURL());
                        }
                        return appCtxResources;
                    }
                    File appXmlFile = new File(locationFile, "META-INF" + File.separator + "spring" + File.separator + "application-context.xml");
                    if (appXmlFile.exists()) {
                        appCtxResources.add(appXmlFile.toURI().toURL());
                        return appCtxResources;
                    }
                    break block20;
                }
                catch (IOException e) {
                    throw new ContributionReadException("Error reading manifest " + manifestFile);
                }
            }
            if (locationFile.isFile() && locationFile.getName().endsWith(".jar")) {
                try {
                    Attributes mainAttrs;
                    String appCtxPath;
                    JarFile jf = new JarFile(locationFile);
                    Manifest mf = jf.getManifest();
                    if (mf != null && (appCtxPath = (mainAttrs = mf.getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path3 : cxtPaths = appCtxPath.split(";")) {
                            JarEntry je = jf.getJarEntry(path3);
                            if (je == null) continue;
                            appCtxResources.add(new URL("jar:" + locationFile.toURI().toURL() + "!/" + appCtxPath));
                        }
                        return appCtxResources;
                    }
                    JarEntry je = jf.getJarEntry("META-INF/spring/application-context.xml");
                    if (je != null) {
                        appCtxResources.add(new URL("jar:" + locationFile.toURI().toURL() + "!/" + "META-INF" + "/" + "spring" + "/" + "application-context.xml"));
                        return appCtxResources;
                    }
                    break block20;
                }
                catch (IOException e) {
                    throw new ContributionReadException("SpringXMLLoader getApplicationContextResource:  IO exception reading context file.", e);
                }
            }
            if (locationFile.getName().endsWith(".xml")) {
                appCtxResources.add(url);
                return appCtxResources;
            }
            try {
                if (locationFile.getPath().indexOf(".jar") > 0) {
                    Manifest mf;
                    Attributes mainAttrs;
                    String appCtxPath;
                    String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                    JarFile jf = new JarFile(jarPath);
                    JarEntry je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + "META-INF" + "/" + "MANIFEST.MF");
                    if (je != null && (appCtxPath = (mainAttrs = (mf = new Manifest(jf.getInputStream(je))).getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path4 : cxtPaths = appCtxPath.split(";")) {
                            je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + path4);
                            if (je == null) continue;
                            appCtxResources.add(new URL("jar:" + url.getPath() + "/" + path4));
                            return appCtxResources;
                        }
                    }
                    if ((je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + "META-INF" + "/" + "spring" + "/" + "application-context.xml")) != null) {
                        appCtxResources.add(new URL("jar:" + url.getPath() + "/" + "META-INF" + "/" + "spring" + "/" + "application-context.xml"));
                        return appCtxResources;
                    }
                }
            }
            catch (IOException e) {
                throw new ContributionReadException("Error reading manifest " + manifestFile);
            }
        }
        throw new ContributionReadException("SpringXMLComponentTypeLoader getApplicationContextResource: unable to read resource file " + url);
    }

    public Service createService(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(name);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return service;
    }

    private Reference createReference(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        reference.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            reference.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return reference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContextClassLoader
    extends ClassLoader {
        private ModelResolver resolver;

        public ContextClassLoader(ModelResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return SpringXMLComponentTypeLoader.this.resolveClass(this.resolver, name);
        }

        @Override
        protected URL findResource(String name) {
            try {
                return SpringXMLComponentTypeLoader.this.resolveLocation(this.resolver, name);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            URL url = this.findResource(name);
            if (url != null) {
                return Collections.enumeration(Arrays.asList(url));
            }
            List urls = Collections.emptyList();
            return Collections.enumeration(urls);
        }
    }
}

