/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.invocation.SpringImplementationTie;
import org.apache.tuscany.sca.implementation.spring.invocation.SpringInvocationException;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class SpringContextStub {
    private Object tie;
    private Method startMethod;
    private Method closeMethod;
    private Method getBeanMethod;

    public SpringContextStub(RuntimeComponent component, SpringImplementation implementation, ProxyFactory proxyService, JavaPropertyValueObjectFactory propertyValueObjectFactory, boolean annotationSupport, String versionSupported) {
        this.initTie(component, implementation, propertyValueObjectFactory, annotationSupport, versionSupported);
    }

    private void initTie(RuntimeComponent component, SpringImplementation implementation, JavaPropertyValueObjectFactory propertyValueObjectFactory, boolean annotationSupport, String versionSupported) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> stubClass = Class.forName("org.apache.tuscany.sca.implementation.spring.runtime.context.SpringImplementationStub", true, cl);
            Constructor<?> stubConstructor = stubClass.getConstructor(Object.class);
            Object stub = stubConstructor.newInstance(new SpringImplementationTie(implementation, component, propertyValueObjectFactory));
            Class<?> tieClass = Class.forName("org.apache.tuscany.sca.implementation.spring.runtime.context.SpringContextTie", true, cl);
            Constructor<?> tieConstructor = tieClass.getConstructor(stubClass, List.class, Boolean.TYPE, String.class);
            this.tie = tieConstructor.newInstance(stub, implementation.getResource(), annotationSupport, versionSupported);
            this.startMethod = tieClass.getMethod("start", new Class[0]);
            this.closeMethod = tieClass.getMethod("close", new Class[0]);
            this.getBeanMethod = tieClass.getMethod("getBean", String.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.startMethod.invoke(this.tie, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.closeMethod.invoke(this.tie, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object getBean(String id) throws SpringInvocationException {
        try {
            return this.getBeanMethod.invoke(this.tie, id);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

