/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.invocation;

import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.MediatorImpl;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.invocation.ConfigurationPropertiesExtensionPoint;
import org.apache.tuscany.sca.implementation.spring.invocation.DefaultConfigurationPropertiesExtensionPoint;
import org.apache.tuscany.sca.implementation.spring.invocation.SpringImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementationProviderFactory
implements ImplementationProviderFactory<SpringImplementation> {
    private ProxyFactory proxyFactory;
    private JavaPropertyValueObjectFactory propertyFactory;
    private ConfigurationPropertiesExtensionPoint configProperties;
    private boolean annotationSupport;
    private String versionSupported;

    public SpringImplementationProviderFactory(ExtensionPointRegistry extensionPoints) {
        ProxyFactoryExtensionPoint proxyFactories = extensionPoints.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        this.proxyFactory = new ExtensibleProxyFactory(proxyFactories);
        this.configProperties = extensionPoints.getExtensionPoint(ConfigurationPropertiesExtensionPoint.class);
        if (this.configProperties == null) {
            this.configProperties = new DefaultConfigurationPropertiesExtensionPoint();
        }
        this.annotationSupport = this.configProperties.isAnnotationSupported();
        this.versionSupported = this.configProperties.getSupportedVersion();
        this.propertyFactory = new JavaPropertyValueObjectFactory(new MediatorImpl(extensionPoints));
    }

    @Override
    public ImplementationProvider createImplementationProvider(RuntimeComponent component, SpringImplementation implementation) {
        return new SpringImplementationProvider(component, implementation, this.proxyFactory, this.propertyFactory, this.annotationSupport, this.versionSupported);
    }

    @Override
    public Class<SpringImplementation> getModelType() {
        return SpringImplementation.class;
    }
}

