/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.invocation;

import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.invocation.ComponentTie;
import org.apache.tuscany.sca.implementation.spring.invocation.PropertyValueTie;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementationTie {
    private SpringImplementation implementation;
    private RuntimeComponent component;
    private JavaPropertyValueObjectFactory propertyFactory;

    public SpringImplementationTie(SpringImplementation implementation, RuntimeComponent component, JavaPropertyValueObjectFactory propertyFactory) {
        this.implementation = implementation;
        this.component = component;
        this.propertyFactory = propertyFactory;
    }

    public String getURI() {
        throw new IllegalStateException("Not yet impl");
    }

    public String getComponentName() {
        return this.component.getName();
    }

    private <B> B getPropertyBean(Class requiredType, String name) {
        B propertyObject = null;
        List<ComponentProperty> props = this.component.getProperties();
        for (ComponentProperty prop : props) {
            if (!prop.getName().equals(name)) continue;
            ObjectFactory factory = this.propertyFactory.createValueFactory((Property)prop, prop.getValue(), requiredType);
            propertyObject = (B)factory.getInstance();
        }
        return propertyObject;
    }

    private <B> B getService(Class<B> businessInterface, String referenceName) {
        return this.component.getComponentContext().getService(businessInterface, referenceName);
    }

    public Object getBean(String name, Class requiredType) {
        System.out.println("Spring parent context - getBean called for name: " + name);
        for (Reference reference : this.implementation.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            if (requiredType == null) {
                JavaInterface javaInterface = (JavaInterface)reference.getInterfaceContract().getInterface();
                requiredType = javaInterface.getJavaClass();
            }
            return this.getService(requiredType, reference.getName());
        }
        for (Property property : this.implementation.getProperties()) {
            if (!property.getName().equals(name)) continue;
            if (requiredType == null) {
                requiredType = this.implementation.getPropertyClass(name);
            }
            return this.getPropertyBean(requiredType, property.getName());
        }
        throw new RuntimeException("Unable to find Bean with name " + name);
    }

    public Object getComponentTie() {
        return new ComponentTie(this.component);
    }

    public Object getPropertyValueTie() {
        return new PropertyValueTie(this.component, this.propertyFactory);
    }

    public ClassLoader getClassLoader() {
        return this.implementation.getClassLoader();
    }
}

