/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.implementation.spring.SpringBeanElement;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.invocation.SpringContextStub;
import org.apache.tuscany.sca.implementation.spring.invocation.SpringInvocationException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class SpringInvoker
implements Invoker {
    private Method theMethod = null;
    private Object bean;
    private SpringBeanElement beanElement;
    private boolean badInvoker = false;
    private SpringContextStub springContext;
    private Operation operation;

    public SpringInvoker(RuntimeComponent component, SpringContextStub springContext, RuntimeComponentService service, Operation operation) {
        this.springContext = springContext;
        this.operation = operation;
        SpringImplementation theImplementation = (SpringImplementation)component.getImplementation();
        this.beanElement = theImplementation.getBeanFromService(service.getService());
        if (this.beanElement == null) {
            this.badInvoker = true;
            return;
        }
    }

    private void setupMethod() throws SpringInvocationException {
        try {
            this.bean = this.springContext.getBean(this.beanElement.getId());
            Class<?> beanClass = this.bean.getClass();
            this.theMethod = JavaInterfaceUtil.findMethod(beanClass, this.operation);
        }
        catch (NoSuchMethodException e) {
            throw new SpringInvocationException(e);
        }
    }

    private Object doInvoke(Object payload) throws SpringInvocationException {
        if (this.theMethod == null) {
            this.setupMethod();
        }
        if (this.badInvoker) {
            throw new SpringInvocationException("Spring invoker incorrectly configured");
        }
        try {
            Object ret = payload != null && !payload.getClass().isArray() ? this.theMethod.invoke(this.bean, payload) : this.theMethod.invoke(this.bean, (Object[])payload);
            return ret;
        }
        catch (InvocationTargetException e) {
            throw new SpringInvocationException("Spring invoker invoke method '" + this.theMethod.getName() + "' error.", e.getCause());
        }
        catch (Exception e) {
            throw new SpringInvocationException("Spring invoker invoke method '" + this.theMethod.getName() + "' error.", e);
        }
    }

    public Message invoke(Message msg) {
        try {
            Object resp = this.doInvoke(msg.getBody());
            msg.setBody(resp);
        }
        catch (SpringInvocationException e) {
            msg.setFaultBody(e.getCause());
        }
        catch (Throwable e) {
            msg.setFaultBody(e);
        }
        return msg;
    }
}

