/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.processor;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.osoa.sca.annotations.ComponentName;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNameAnnotationProcessor
implements BeanPostProcessor {
    private Class<? extends Annotation> componentNameAnnotationType = ComponentName.class;
    private String componentName;

    public ComponentNameAnnotationProcessor(String componentName) {
        this.componentName = componentName;
    }

    protected Class<? extends Annotation> getComponentNameAnnotationType() {
        return this.componentNameAnnotationType;
    }

    public void setComponentNameAnnotationType(Class<? extends Annotation> componentNameAnnotationType) {
        Assert.notNull(componentNameAnnotationType, (String)"'componentNameAnnotationType' type must not be null.");
        this.componentNameAnnotationType = componentNameAnnotationType;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processAnnotation(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processAnnotation(final Object bean) {
        Class<?> clazz = bean.getClass();
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                Annotation annotation = field.getAnnotation(ComponentNameAnnotationProcessor.this.getComponentNameAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("ComponentName annotation is not supported on static fields");
                    }
                    if (Modifier.isPrivate(field.getModifiers())) {
                        throw new IllegalStateException("ComponentName annotation is not supported on private fields");
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    if (field.getType().getName().equals("java.lang.String")) {
                        String nameObj = ComponentNameAnnotationProcessor.this.componentName;
                        if (nameObj != null) {
                            ReflectionUtils.setField((Field)field, (Object)bean, (Object)nameObj);
                        }
                    } else {
                        throw new IllegalStateException("ComponentName annotation is supported only on java.lang.String field type.");
                    }
                }
            }
        });
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Annotation annotation = method.getAnnotation(ComponentNameAnnotationProcessor.this.getComponentNameAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("ComponentName annotation is not supported on static methods");
                    }
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalStateException("ComponentName annotation is not supported on private methods");
                    }
                    if (method.getParameterTypes().length == 0) {
                        throw new IllegalStateException("ComponentName annotation requires at least one argument: " + method);
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                    if (pd.getPropertyType().getName().equals("java.lang.String")) {
                        String nameObj = ComponentNameAnnotationProcessor.this.componentName;
                        if (nameObj != null) {
                            try {
                                pd.getWriteMethod().invoke(bean, nameObj);
                            }
                            catch (Throwable e) {
                                throw new FatalBeanException("Problem injecting reference:  " + e.getMessage(), e);
                            }
                        }
                    } else {
                        throw new IllegalStateException("ComponentName annotation is supported only on java.lang.String field type.");
                    }
                }
            }
        });
    }
}

