/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.processor;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.tuscany.sca.implementation.spring.processor.PropertyValueStub;
import org.osoa.sca.annotations.Property;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAnnotationProcessor
implements BeanPostProcessor {
    private Class<? extends Annotation> propertyAnnotationType = Property.class;
    private PropertyValueStub propertyValue;

    public PropertyAnnotationProcessor(PropertyValueStub propertyValue) {
        this.propertyValue = propertyValue;
    }

    protected Class<? extends Annotation> getPropertyAnnotationType() {
        return this.propertyAnnotationType;
    }

    public void setPropertyAnnotationType(Class<? extends Annotation> propertyAnnotationType) {
        Assert.notNull(propertyAnnotationType, (String)"'propertyAnnotationType' type must not be null.");
        this.propertyAnnotationType = propertyAnnotationType;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processAnnotation(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processAnnotation(final Object bean) {
        Class<?> clazz = bean.getClass();
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Property annotation = (Property)method.getAnnotation(PropertyAnnotationProcessor.this.getPropertyAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on static methods");
                    }
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on private methods");
                    }
                    if (method.getParameterTypes().length == 0) {
                        throw new IllegalStateException("Property annotation requires at least one argument: " + method);
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                    if (pd != null) {
                        String propName = annotation.name();
                        if ("".equals(propName)) {
                            PropertyAnnotationProcessor.this.injectProperty(bean, pd, PropertyAnnotationProcessor.this.propertyValue.getPropertyObj(pd.getPropertyType(), pd.getName()));
                        } else {
                            PropertyAnnotationProcessor.this.injectProperty(bean, pd, PropertyAnnotationProcessor.this.propertyValue.getPropertyObj(pd.getPropertyType(), propName));
                        }
                    }
                }
            }
        });
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                Property annotation = (Property)field.getAnnotation(PropertyAnnotationProcessor.this.getPropertyAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on static fields");
                    }
                    if (Modifier.isPrivate(field.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on private fields");
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    Object propertyObj = null;
                    String propName = annotation.name();
                    propertyObj = "".equals(propName) ? PropertyAnnotationProcessor.this.propertyValue.getPropertyObj(field.getType(), field.getName()) : PropertyAnnotationProcessor.this.propertyValue.getPropertyObj(field.getType(), propName);
                    if (propertyObj != null) {
                        ReflectionUtils.setField((Field)field, (Object)bean, (Object)propertyObj);
                    }
                }
            }
        });
    }

    public void injectProperty(Object bean, PropertyDescriptor pd, Object propertyObj) {
        if (propertyObj != null) {
            try {
                pd.getWriteMethod().invoke(bean, propertyObj);
            }
            catch (Throwable e) {
                throw new FatalBeanException("Problem injecting property:  " + e.getMessage(), e);
            }
        }
    }
}

