/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.runtime.context;

import java.net.URL;
import java.util.List;
import org.apache.tuscany.sca.implementation.spring.processor.ComponentNameAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.ComponentStub;
import org.apache.tuscany.sca.implementation.spring.processor.ConstructorAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.InitDestroyAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.PropertyAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.PropertyValueStub;
import org.apache.tuscany.sca.implementation.spring.processor.ReferenceAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.runtime.context.SCAGenericApplicationContext;
import org.apache.tuscany.sca.implementation.spring.runtime.context.SCAParentApplicationContext;
import org.apache.tuscany.sca.implementation.spring.runtime.context.SpringImplementationStub;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContextTie {
    private AbstractApplicationContext springContext;
    private SpringImplementationStub implementation;
    private boolean isAnnotationSupported;
    private String versionSupported;

    public SpringContextTie(SpringImplementationStub implementation, List<URL> resource, boolean annotationSupport, String versionSupported) throws Exception {
        this.implementation = implementation;
        this.isAnnotationSupported = annotationSupport;
        this.versionSupported = versionSupported;
        if (!this.versionSupported.equals("ANY") && SpringVersion.getVersion() != null && !SpringVersion.getVersion().equals(versionSupported)) {
            throw new RuntimeException("Unsupported version: Use only Spring Framework Version " + versionSupported);
        }
        SCAParentApplicationContext scaParentContext = new SCAParentApplicationContext(implementation);
        this.springContext = this.createApplicationContext(scaParentContext, resource);
    }

    public void start() {
        this.springContext.refresh();
        this.springContext.start();
    }

    public void close() {
        this.springContext.close();
        if (this.springContext instanceof GenericApplicationContext) {
            this.springContext.stop();
        }
    }

    private AbstractApplicationContext createApplicationContext(SCAParentApplicationContext scaParentContext, List<URL> resources) {
        XmlBeanFactory beanFactory = null;
        SCAGenericApplicationContext appContext = null;
        if (resources.size() > 1) {
            SCAGenericApplicationContext appCtx = new SCAGenericApplicationContext(scaParentContext, this.implementation.getClassLoader());
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appCtx);
            for (URL resource : resources) {
                xmlReader.loadBeanDefinitions((Resource)new UrlResource(resource));
            }
            xmlReader.setBeanClassLoader(this.implementation.getClassLoader());
            if (this.isAnnotationSupported) {
                this.includeAnnotationProcessors(appCtx.getBeanFactory());
            }
            return appCtx;
        }
        beanFactory = new XmlBeanFactory((Resource)new UrlResource(resources.get(0)));
        beanFactory.setBeanClassLoader(this.implementation.getClassLoader());
        if (this.isAnnotationSupported) {
            this.includeAnnotationProcessors((ConfigurableListableBeanFactory)beanFactory);
        }
        appContext = new SCAGenericApplicationContext((DefaultListableBeanFactory)beanFactory, scaParentContext, this.implementation.getClassLoader());
        return appContext;
    }

    public Object getBean(String id) throws BeansException {
        return this.springContext.getBean(id);
    }

    private void includeAnnotationProcessors(ConfigurableListableBeanFactory beanFactory) {
        InitDestroyAnnotationProcessor initDestroyProcessor = new InitDestroyAnnotationProcessor();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)initDestroyProcessor);
        ComponentStub component = new ComponentStub(this.implementation.getComponentTie());
        ReferenceAnnotationProcessor referenceProcessor = new ReferenceAnnotationProcessor(component);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)referenceProcessor);
        PropertyValueStub pvs = new PropertyValueStub(this.implementation.getPropertyValueTie());
        PropertyAnnotationProcessor propertyProcessor = new PropertyAnnotationProcessor(pvs);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)propertyProcessor);
        ComponentNameAnnotationProcessor componentNameProcessor = new ComponentNameAnnotationProcessor(this.implementation.getComponentName());
        beanFactory.addBeanPostProcessor((BeanPostProcessor)componentNameProcessor);
        ConstructorAnnotationProcessor constructorProcessor = new ConstructorAnnotationProcessor();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)constructorProcessor);
    }
}

