/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.introspect.SpringXMLComponentTypeLoader;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<SpringImplementation> {
    private static final String LOCATION = "location";
    private static final String IMPLEMENTATION_SPRING = "implementation.spring";
    private static final QName IMPLEMENTATION_SPRING_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.spring");
    private static final String MSG_LOCATION_MISSING = "Reading implementation.spring - location attribute missing";
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaFactory;
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private Monitor monitor;
    private ModelFactoryExtensionPoint factories;

    public SpringImplementationProcessor(ExtensionPointRegistry extensionPoints, Monitor monitor) {
        this.factories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = this.factories.getFactory(AssemblyFactory.class);
        this.javaFactory = this.factories.getFactory(JavaInterfaceFactory.class);
        this.policyFactory = this.factories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public SpringImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        SpringImplementation springImplementation = null;
        String springLocation = SpringImplementationProcessor.getURIString(reader, LOCATION);
        if (springLocation != null) {
            springImplementation = new SpringImplementation();
            springImplementation.setLocation(springLocation);
            springImplementation.setUnresolved(true);
            this.processComponentType(springImplementation);
        } else {
            this.error("LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        this.policyProcessor.readPolicies(springImplementation, reader);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_SPRING_QNAME.equals(reader.getName()))) {
        }
        return springImplementation;
    }

    private void processComponentType(SpringImplementation springImplementation) {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        springImplementation.setComponentType(componentType);
    }

    @Override
    public void write(SpringImplementation springImplementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", IMPLEMENTATION_SPRING);
        this.policyProcessor.writePolicyAttributes(springImplementation, writer);
        if (springImplementation.getLocation() != null) {
            writer.writeAttribute(LOCATION, springImplementation.getLocation());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(SpringImplementation springImplementation, ModelResolver resolver) throws ContributionResolveException {
        if (springImplementation == null) {
            return;
        }
        SpringXMLComponentTypeLoader springLoader = new SpringXMLComponentTypeLoader(this.factories, this.assemblyFactory, this.javaFactory, this.policyFactory);
        try {
            springLoader.load(springImplementation, resolver);
        }
        catch (ContributionReadException e) {
            ContributionResolveException ce = new ContributionResolveException(e);
            this.error("ContributionResolveException", (Object)resolver, ce);
            throw ce;
        }
        ComponentType ct = springImplementation.getComponentType();
        if (ct.isUnresolved()) {
            ComponentType componentType = resolver.resolveModel(ComponentType.class, ct);
            if (componentType.isUnresolved()) {
                this.error("UnableToResolveComponentType", (Object)resolver, new Object[0]);
            } else {
                springImplementation.setComponentType(componentType);
                springImplementation.setUnresolved(false);
            }
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_SPRING_QNAME;
    }

    @Override
    public Class<SpringImplementation> getModelType() {
        return SpringImplementation.class;
    }
}

