/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.implementation.web.ContextScriptProcessor;
import org.apache.tuscany.sca.implementation.web.JSONRPCScripProcessor;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class ComponentContextServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final String HEADER = "/** --- Apache Tuscany componentContext.js --- */\n";
    protected static final String FOOTER = "/** --- Apache Tuscany componentContext.js EOF --- */\n";
    public static final String COMPONENT_CONTEXT_SCRIPT_URI = "org.apache.tuscany.sca.componentContext.js";
    protected transient Map<String, Object> attributes = new HashMap<String, Object>();
    protected transient ServletContext servletContext;
    private transient List<ContextScriptProcessor> contextScriptProcessors = new ArrayList<ContextScriptProcessor>();

    public ComponentContextServlet() {
        this.contextScriptProcessors.add(new JSONRPCScripProcessor());
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletContext = servletConfig.getServletContext();
        if (this.attributes.size() > 0) {
            for (String name : this.attributes.keySet()) {
                this.servletContext.setAttribute(name, this.attributes.get(name));
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.write(HEADER);
        this.doScriptInit(req, response);
        this.doScriptReferences(req, response);
        out.write(FOOTER);
        out.flush();
        out.close();
    }

    protected void doScriptInit(HttpServletRequest req, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
        PrintWriter out = response.getWriter();
        out.println("if (SCA == undefined) var SCA = new Object();");
        out.println("if (SCA.componentContext == undefined) {");
        out.println("   SCA.componentContext = new Object();");
        out.println("   SCA.componentContext.serviceNames = [];");
        out.println("   SCA.componentContext.serviceProxys = [];");
        out.println("   SCA.componentContext.getService = function(serviceName){");
        out.println("      var i = SCA.componentContext.serviceNames.indexOf(serviceName);");
        out.println("      return SCA.componentContext.serviceProxys[i];");
        out.println("   };");
        out.println("   if (componentContext == undefined) var componentContext = SCA.componentContext;");
        out.println("}");
        for (ContextScriptProcessor csp : this.contextScriptProcessors) {
            csp.scriptInit(req, response);
        }
    }

    protected void doScriptReferences(HttpServletRequest req, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
        PrintWriter out = response.getWriter();
        out.write("// SCA References\n");
        RuntimeComponent component = (RuntimeComponent)this.servletContext.getAttribute("org.apache.tuscany.sca.implementation.web.RuntimeComponent");
        for (ComponentReference cr : component.getReferences()) {
            String ref = "// SCA Reference " + cr.getName() + "\n";
            out.write(ref);
            for (ContextScriptProcessor csp : this.contextScriptProcessors) {
                csp.scriptReference(cr, req, response);
            }
        }
        out.write("\n// SCA References end.\n");
    }

    protected void doScriptProperties(HttpServletRequest req, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
    }

    public void setAttribute(String name, Object value) {
        if (this.servletContext != null) {
            this.servletContext.setAttribute(name, value);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void addContextScriptProcessor(ContextScriptProcessor csp) {
        this.contextScriptProcessors.add(csp);
    }
}

