/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.implementation.web.ContextScriptProcessor;

public class JSONRPCScripProcessor
implements ContextScriptProcessor {
    public void scriptInit(HttpServletRequest req, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("jsonrpc.js");
        if (is != null) {
            int i;
            while ((i = is.read()) != -1) {
                out.write(i);
            }
        }
        out.println();
    }

    public void scriptReference(ComponentReference cr, HttpServletRequest req, HttpServletResponse response) throws IOException {
        for (Binding b : cr.getBindings()) {
            if (!"org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding".equals(b.getClass().getName())) continue;
            PrintWriter out = response.getWriter();
            out.println("SCA.componentContext.serviceNames.push('" + cr.getName() + "');");
            out.println("SCA.componentContext.serviceProxys.push(new JSONRpcClient('" + cr.getReference().getTargets().get(0).getName() + "').Service);");
        }
    }
}

