/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.introspect;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicatePropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalPropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.osoa.sca.annotations.Property;

public class PropertyProcessor
extends BaseJavaClassVisitor {
    public PropertyProcessor(AssemblyFactory assemblyFactory) {
        super(assemblyFactory);
    }

    private boolean removeProperty(JavaElementImpl prop, JavaImplementation type) {
        if (prop == null) {
            return false;
        }
        List<org.apache.tuscany.sca.assembly.Property> props = type.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            if (!props.get(i).getName().equals(prop.getName())) continue;
            props.remove(i);
            return true;
        }
        return false;
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties;
        JavaElementImpl prop;
        Property annotation = method.getAnnotation(Property.class);
        if (annotation == null) {
            return;
        }
        if (!JavaIntrospectionHelper.isSetter(method)) {
            throw new IllegalPropertyException("Annotated method is not a setter: " + method, method);
        }
        String name = annotation.name();
        if ((name == null || "".equals(name)) && (name = method.getName()).startsWith("set")) {
            name = JavaIntrospectionHelper.toPropertyName(method.getName());
        }
        if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() != ElementType.FIELD) {
            throw new DuplicatePropertyException(name);
        }
        this.removeProperty(prop, type);
        JavaElementImpl element = new JavaElementImpl(method, 0);
        org.apache.tuscany.sca.assembly.Property property = this.createProperty(name, element);
        property.setMustSupply(annotation.required());
        type.getProperties().add(property);
        properties.put(name, element);
    }

    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties;
        JavaElementImpl prop;
        Property annotation = field.getAnnotation(Property.class);
        if (annotation == null) {
            return;
        }
        String name = annotation.name();
        if (name == null) {
            name = "";
        }
        if ("".equals(name) || name.equals(field.getType().getName())) {
            name = field.getName();
        }
        if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() == ElementType.FIELD) {
            throw new DuplicatePropertyException(name);
        }
        if (prop == null) {
            JavaElementImpl element = new JavaElementImpl(field);
            org.apache.tuscany.sca.assembly.Property property = this.createProperty(name, element);
            property.setMustSupply(annotation.required());
            type.getProperties().add(property);
            properties.put(name, element);
        }
    }

    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
    }

    protected org.apache.tuscany.sca.assembly.Property createProperty(String name, JavaElementImpl element) throws IntrospectionException {
        org.apache.tuscany.sca.assembly.Property property = this.assemblyFactory.createProperty();
        property.setName(name);
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(element.getType(), element.getGenericType());
        property.setXSDType(JavaXMLMapper.getXMLType(baseType));
        Class<?> javaType = element.getType();
        if (javaType.isArray() || Collection.class.isAssignableFrom(javaType)) {
            property.setMany(true);
        }
        return property;
    }
}

