/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.runtime;

import java.util.List;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.implementation.web.ComponentContextServlet;
import org.apache.tuscany.sca.implementation.web.ContextScriptProcessorExtensionPoint;
import org.apache.tuscany.sca.implementation.web.DefaultContextScriptProcessorExtensionPoint;
import org.apache.tuscany.sca.implementation.web.WebImplementation;
import org.apache.tuscany.sca.implementation.web.runtime.ComponentContextProxy;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebImplementationProviderFactory
implements ImplementationProviderFactory<WebImplementation> {
    private ServletHost servletHost;
    private ComponentContextServlet contextServlet;

    public WebImplementationProviderFactory(ExtensionPointRegistry extensionPoints) {
        ServletHostExtensionPoint servletHosts = extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        List<ServletHost> hosts = servletHosts.getServletHosts();
        if (!hosts.isEmpty()) {
            this.servletHost = hosts.get(0);
        }
        this.contextServlet = new ComponentContextServlet();
        DefaultContextScriptProcessorExtensionPoint dcspep = (DefaultContextScriptProcessorExtensionPoint)extensionPoints.getExtensionPoint(ContextScriptProcessorExtensionPoint.class);
        dcspep.setComponentContextServlet(this.contextServlet);
    }

    @Override
    public ImplementationProvider createImplementationProvider(RuntimeComponent component, WebImplementation implementation) {
        this.servletHost.addServletMapping("org.osoa.sca.componentContext.js", (Servlet)this.contextServlet);
        this.contextServlet.setAttribute("org.osoa.sca.ComponentContext", new ComponentContextProxy(component));
        this.contextServlet.setAttribute("org.apache.tuscany.sca.implementation.web.RuntimeComponent", component);
        return new ImplementationProvider(){

            public Invoker createInvoker(RuntimeComponentService arg0, Operation arg1) {
                throw new UnsupportedOperationException("Components using implementation.web have no services");
            }

            public void start() {
            }

            public void stop() {
            }

            public boolean supportsOneWayInvocation() {
                return false;
            }
        };
    }

    @Override
    public Class<WebImplementation> getModelType() {
        return WebImplementation.class;
    }
}

