/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbReferenceInfo;
import org.apache.tuscany.sca.contribution.jee.EnvEntryInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEExtension;
import org.apache.tuscany.sca.contribution.jee.JavaEEOptionalExtension;
import org.apache.tuscany.sca.contribution.jee.JspReferenceTagInfo;
import org.apache.tuscany.sca.contribution.jee.WebModuleInfo;
import org.apache.tuscany.sca.contribution.jee.impl.WebModuleInfoImpl;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.java.DefaultJavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ComponentNameProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ContextProcessor;
import org.apache.tuscany.sca.implementation.web.WebImplementation;
import org.apache.tuscany.sca.implementation.web.WebImplementationFactory;
import org.apache.tuscany.sca.implementation.web.introspect.PropertyProcessor;
import org.apache.tuscany.sca.implementation.web.introspect.ReferenceProcessor;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WebImplementation> {
    private static final QName IMPLEMENTATION_WEB = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.web");
    private AssemblyFactory assemblyFactory;
    private WebImplementationFactory implementationFactory;
    private Monitor monitor;
    private JavaEEExtension jeeExtension;
    private JavaEEOptionalExtension jeeOptionalExtension;
    private JavaImplementationFactory javaImplementationFactory;
    private JavaInterfaceFactory javaInterfaceFactory;

    public WebImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(WebImplementationFactory.class);
        this.jeeExtension = modelFactories.getFactory(JavaEEExtension.class);
        this.jeeOptionalExtension = modelFactories.getFactory(JavaEEOptionalExtension.class);
        this.monitor = monitor;
        this.javaImplementationFactory = new DefaultJavaImplementationFactory();
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.javaImplementationFactory.addClassVisitor(new ReferenceProcessor(this.assemblyFactory, this.javaInterfaceFactory));
        this.javaImplementationFactory.addClassVisitor(new PropertyProcessor(this.assemblyFactory));
        this.javaImplementationFactory.addClassVisitor(new ComponentNameProcessor(this.assemblyFactory));
        this.javaImplementationFactory.addClassVisitor(new ContextProcessor(this.assemblyFactory));
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_WEB;
    }

    @Override
    public Class<WebImplementation> getModelType() {
        return WebImplementation.class;
    }

    @Override
    public WebImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        WebImplementation implementation = this.implementationFactory.createWebImplementation();
        implementation.setUnresolved(true);
        String webURI = this.getString(reader, "web-uri");
        if (webURI != null) {
            implementation.setWebURI(webURI);
            implementation.setURI(webURI);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_WEB.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(WebImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        String uri = implementation.getURI();
        if (uri != null) {
            WebModuleInfo webModuleInfo = new WebModuleInfoImpl();
            webModuleInfo.setUri(URI.create(uri));
            webModuleInfo = resolver.resolveModel(WebModuleInfo.class, webModuleInfo);
            if (this.jeeOptionalExtension != null) {
                ComponentType ct = this.jeeOptionalExtension.createImplementationWebComponentType(webModuleInfo);
                implementation.getReferences().addAll(ct.getReferences());
                implementation.getProperties().addAll(ct.getProperties());
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (Property property : ct.getProperties()) {
                    propertyNames.add(property.getName());
                }
                for (Map.Entry entry : webModuleInfo.getEjbReferences().entrySet()) {
                    EjbReferenceInfo ejbRef = (EjbReferenceInfo)entry.getValue();
                    implementation.getOptExtensionReferenceInjectionPoints().put(ejbRef.injectionTarget, ejbRef.businessInterface);
                }
                for (Map.Entry entry : webModuleInfo.getEnvEntries().entrySet()) {
                    EnvEntryInfo envEntry = (EnvEntryInfo)entry.getValue();
                    if (!propertyNames.contains(envEntry.name.replace("/", "_"))) continue;
                    implementation.getOptExtensionPropertyInjectionPoints().put(envEntry.name, envEntry.type);
                }
            }
            ArrayList webArtifacts = new ArrayList();
            webArtifacts.addAll(webModuleInfo.getServletClasses());
            webArtifacts.addAll(webModuleInfo.getFilterClasses());
            webArtifacts.addAll(webModuleInfo.getListenerClasses());
            webArtifacts.addAll(webModuleInfo.getJSFClasses());
            JavaImplementation ji = this.javaImplementationFactory.createJavaImplementation();
            for (Class clazz : webArtifacts) {
                try {
                    this.javaImplementationFactory.createJavaImplementation(ji, clazz);
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
            }
            implementation.getReferences().addAll(ji.getReferences());
            implementation.getProperties().addAll(ji.getProperties());
            for (Map.Entry entry : ji.getReferenceMembers().entrySet()) {
                implementation.getReferenceInjectionPoints().put((String)entry.getKey(), (JavaElementImpl)entry.getValue());
            }
            for (Map.Entry entry : ji.getPropertyMembers().entrySet()) {
                implementation.getPropertyInjectionPoints().put((String)entry.getKey(), (JavaElementImpl)entry.getValue());
            }
            for (Map.Entry entry : ji.getResources().entrySet()) {
                implementation.getResourceInjectionPoints().put((String)entry.getKey(), (JavaResourceImpl)entry.getValue());
            }
            for (JspReferenceTagInfo jspReferenceTagInfo : webModuleInfo.getJspReferenceTags()) {
                ComponentReference ref = this.assemblyFactory.createComponentReference();
                ref.setName(jspReferenceTagInfo.name);
                JavaInterfaceContract intfContract = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    intfContract.setInterface(this.javaInterfaceFactory.createJavaInterface(jspReferenceTagInfo.type));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                ref.setInterfaceContract(intfContract);
                implementation.getReferences().add(ref);
            }
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI("WEB-INF/web.componentType");
            componentType = resolver.resolveModel(ComponentType.class, componentType);
            if (!componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
            }
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(WebImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_WEB.getNamespaceURI(), IMPLEMENTATION_WEB.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("web-uri", implementation.getWebURI()));
        this.writeEnd(writer);
    }
}

