/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.widget.Widget;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetImplementationImpl
implements WidgetImplementation {
    private Service widgetService;
    private List<Reference> references = new ArrayList<Reference>();
    private List<Property> properties = new ArrayList<Property>();
    private String location;
    private URL url;
    private boolean unresolved;

    WidgetImplementationImpl(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        JavaInterface javaInterface;
        this.widgetService = assemblyFactory.createService();
        this.widgetService.setName("Widget");
        try {
            javaInterface = javaFactory.createJavaInterface(Widget.class);
        }
        catch (InvalidInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        JavaInterfaceContract interfaceContract = javaFactory.createJavaInterfaceContract();
        interfaceContract.setInterface(javaInterface);
        this.widgetService.setInterfaceContract(interfaceContract);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public URL getLocationURL() {
        return this.url;
    }

    @Override
    public void setLocationURL(URL url) {
        this.url = url;
    }

    @Override
    public ConstrainingType getConstrainingType() {
        return null;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Service> getServices() {
        return Collections.singletonList(this.widgetService);
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public String getURI() {
        return this.location;
    }

    @Override
    public void setConstrainingType(ConstrainingType constrainingType) {
    }

    @Override
    public void setURI(String uri) {
        this.location = uri;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    public String toString() {
        return "Widget : " + this.getLocation();
    }
}

