/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.tuscany;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactory;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactoryExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TuscanyJavaScriptComponentGeneratorImpl
implements ComponentJavaScriptGenerator {
    private static final QName NAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "component.script.generator.tuscany");
    private JavascriptProxyFactoryExtensionPoint javascriptProxyFactories;

    public TuscanyJavaScriptComponentGeneratorImpl(ExtensionPointRegistry extensionPoints) {
        this.javascriptProxyFactories = extensionPoints.getExtensionPoint(JavascriptProxyFactoryExtensionPoint.class);
    }

    public QName getQName() {
        return NAME;
    }

    public void generateJavaScriptCode(RuntimeComponent component, PrintWriter pw) throws IOException {
        pw.println();
        pw.println("/* Apache Tuscany SCA Widget header */");
        pw.println();
        HashMap<String, Boolean> bindingClientProcessed = new HashMap<String, Boolean>();
        for (ComponentReference reference : component.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                Boolean processedFlag;
                JavascriptProxyFactory jsProxyFactory = this.javascriptProxyFactories.getProxyFactory(binding.getClass());
                String bindingProxyName = jsProxyFactory.getJavascriptProxyFile();
                if (bindingProxyName == null || (processedFlag = (Boolean)bindingClientProcessed.get(bindingProxyName)) != null && processedFlag.booleanValue()) continue;
                TuscanyJavaScriptComponentGeneratorImpl.generateJavaScriptBindingProxy(jsProxyFactory, pw);
                bindingClientProcessed.put(bindingProxyName, Boolean.TRUE);
            }
        }
        pw.println();
        pw.println("/* Tuscany Reference/Property injection code */");
        pw.println();
        TuscanyJavaScriptComponentGeneratorImpl.generateJavaScriptNamespace(pw);
        pw.println();
        TuscanyJavaScriptComponentGeneratorImpl.generateJavaScriptPropertyFunction(component, pw);
        pw.println();
        TuscanyJavaScriptComponentGeneratorImpl.generateJavaScriptReferenceFunction(component, this.javascriptProxyFactories, pw);
        pw.println();
        pw.println("/** End of Apache Tuscany SCA Widget */");
        pw.println();
        pw.flush();
        pw.close();
    }

    private static void generateJavaScriptBindingProxy(JavascriptProxyFactory javascriptProxyFactory, PrintWriter pw) throws IOException {
        InputStream is = javascriptProxyFactory.getJavascriptProxyFileAsStream();
        if (is != null) {
            int i;
            while ((i = is.read()) != -1) {
                pw.write(i);
            }
        }
        pw.println();
        pw.println();
    }

    private static void generateJavaScriptNamespace(PrintWriter pw) throws IOException {
        pw.println("if (!tuscany) { \nvar tuscany = {}; \n}");
        pw.println("if (!tuscany.sca) { \ntuscany.sca = {}; \n}");
    }

    private static void generateJavaScriptPropertyFunction(RuntimeComponent component, PrintWriter pw) throws IOException {
        pw.println("tuscany.sca.propertyMap = new String();");
        for (ComponentProperty property : component.getProperties()) {
            String propertyName = property.getName();
            pw.println("tuscany.sca.propertyMap." + propertyName + " = new String(\"" + TuscanyJavaScriptComponentGeneratorImpl.getPropertyValue(property) + "\");");
        }
        pw.println("tuscany.sca.Property = function (name) {");
        pw.println("    return tuscany.sca.propertyMap[name];");
        pw.println("}");
    }

    private static String getPropertyValue(ComponentProperty property) {
        Document doc = (Document)property.getValue();
        Element rootElement = doc.getDocumentElement();
        String value = null;
        if (rootElement.getChildNodes().getLength() > 0) {
            value = rootElement.getChildNodes().item(0).getTextContent();
        }
        return value;
    }

    private static void generateJavaScriptReferenceFunction(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories, PrintWriter pw) throws IOException {
        pw.println("tuscany.sca.referenceMap = new Object();");
        for (ComponentReference reference : component.getReferences()) {
            Binding binding = reference.getBindings().get(0);
            if (binding == null) continue;
            String referenceName = reference.getName();
            JavascriptProxyFactory jsProxyFactory = javascriptProxyFactories.getProxyFactory(binding.getClass());
            pw.println("tuscany.sca.referenceMap." + referenceName + " = new " + jsProxyFactory.createJavascriptReference(reference) + ";");
        }
        pw.println("tuscany.sca.Reference = function (name) {");
        pw.println("    return tuscany.sca.referenceMap[name];");
        pw.println("}");
    }
}

