/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.xquery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.databinding.saxon.SaxonNodeDataBinding;
import org.apache.tuscany.sca.databinding.saxon.SaxonValueDataBinding;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.xquery.XQueryImplementation;
import org.apache.tuscany.sca.implementation.xquery.XQueryInvoker;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class XQueryImplementationProvider
implements ImplementationProvider {
    private RuntimeComponent component;
    private XQueryImplementation implementation;
    private Map<String, Object> referenceProxies = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private JavaPropertyValueObjectFactory javaFactory;

    public XQueryImplementationProvider(RuntimeComponent component, XQueryImplementation implementation, JavaPropertyValueObjectFactory factory) {
        this.component = component;
        this.implementation = implementation;
        this.javaFactory = factory;
        this.init();
    }

    private void init() {
        List<Service> services = this.implementation.getServices();
        for (Service sevice : services) {
            InterfaceContract interfaceContract = sevice.getInterfaceContract();
            this.setDataBinding(interfaceContract.getInterface(), false);
        }
        List<Reference> references = this.implementation.getReferences();
        for (Reference reference : references) {
            InterfaceContract interfaceContract = reference.getInterfaceContract();
            this.setDataBinding(interfaceContract.getInterface(), true);
        }
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        return new XQueryInvoker(service, operation, this.implementation, this.referenceProxies, this.properties);
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        for (ComponentReference reference : this.component.getReferences()) {
            String refName = reference.getName();
            if (refName.startsWith("$self$.")) continue;
            Class<?> interfaze = ((JavaInterface)reference.getInterfaceContract().getInterface()).getJavaClass();
            Object refProxy = this.component.getComponentContext().getService(interfaze, refName);
            this.referenceProxies.put(refName, refProxy);
        }
        for (ComponentProperty property : this.component.getProperties()) {
            String propName = property.getName();
            QName xmlType = property.getXSDType();
            Class clazz = JavaXMLMapper.getJavaType(xmlType);
            Object propertyValue = null;
            if (clazz == null || Object.class.equals((Object)clazz)) {
                propertyValue = property.getValue();
            } else {
                ObjectFactory objfactory = this.javaFactory.createValueFactory((Property)property, property.getValue(), clazz);
                propertyValue = objfactory.getInstance();
            }
            this.properties.put(propName, propertyValue);
        }
    }

    private void setDataBinding(Interface interfaze, boolean isReference) {
        List<Operation> operations = interfaze.getOperations();
        for (Operation operation : operations) {
            DataType outputType;
            operation.setDataBinding(SaxonNodeDataBinding.NAME);
            DataType<List<DataType>> inputType = operation.getInputType();
            if (inputType != null) {
                List<DataType> logical = inputType.getLogical();
                for (DataType inArg : logical) {
                    if ("java:simpleType".equals(inArg.getDataBinding())) {
                        if (isReference) continue;
                        inArg.setDataBinding(SaxonValueDataBinding.NAME);
                        continue;
                    }
                    inArg.setDataBinding(SaxonNodeDataBinding.NAME);
                }
            }
            if ((outputType = operation.getOutputType()) == null) continue;
            if ("java:simpleType".equals(outputType.getDataBinding())) {
                if (isReference) continue;
                outputType.setDataBinding(SaxonValueDataBinding.NAME);
                continue;
            }
            outputType.setDataBinding(SaxonNodeDataBinding.NAME);
        }
    }

    public void stop() {
    }
}

