/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.interfacedef.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeImpl<L>
implements DataType<L> {
    private String dataBinding;
    private WeakReference<Class<?>> physical;
    private WeakReference<Type> genericType;
    private L logical;
    private Map<Class<?>, Object> metaDataMap;

    public DataTypeImpl(Class<?> physical, L logical) {
        this(null, physical, physical, logical);
    }

    public DataTypeImpl(String dataBinding, Class<?> physical, L logical) {
        this(dataBinding, physical, physical, logical);
    }

    public DataTypeImpl(String dataBinding, Class<?> physical, Type genericType, L logical) {
        this.dataBinding = dataBinding;
        this.physical = new WeakReference(physical);
        this.genericType = new WeakReference<Type>(genericType);
        this.logical = logical;
    }

    @Override
    public Class<?> getPhysical() {
        return (Class)this.physical.get();
    }

    @Override
    public void setPhysical(Class<?> physical) {
        this.physical = new WeakReference(physical);
    }

    @Override
    public Type getGenericType() {
        return (Type)this.genericType.get();
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = new WeakReference<Type>(genericType);
    }

    @Override
    public L getLogical() {
        return this.logical;
    }

    @Override
    public void setLogical(L logical) {
        this.logical = logical;
    }

    @Override
    public String getDataBinding() {
        return this.dataBinding;
    }

    @Override
    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataTypeImpl copy = (DataTypeImpl)super.clone();
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataBinding == null ? 0 : this.dataBinding.hashCode());
        result = 31 * result + (this.genericType == null || this.genericType.get() == null ? 0 : ((Type)this.genericType.get()).hashCode());
        result = 31 * result + (this.logical == null ? 0 : this.logical.hashCode());
        result = 31 * result + (this.physical == null || this.physical.get() == null ? 0 : ((Class)this.physical.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeImpl other = (DataTypeImpl)obj;
        if (this.dataBinding == null ? other.dataBinding != null : !this.dataBinding.equals(other.dataBinding)) {
            return false;
        }
        if (this.genericType == null || this.genericType.get() == null ? other.genericType != null : !((Type)this.genericType.get()).equals(other.genericType.get())) {
            return false;
        }
        if (this.logical == null ? other.logical != null : !this.logical.equals(other.logical)) {
            return false;
        }
        return !(this.physical == null || this.physical.get() == null ? other.physical != null : !((Class)this.physical.get()).equals(other.physical.get()));
    }

    @Override
    public <T> T getMetaData(Class<T> type) {
        return this.metaDataMap == null ? null : (T)type.cast(this.metaDataMap.get(type));
    }

    @Override
    public <T> void setMetaData(Class<T> type, T metaData) {
        if (this.metaDataMap == null) {
            this.metaDataMap = new ConcurrentHashMap();
        }
        this.metaDataMap.put(type, metaData);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(256);
        b.append("DataType[");
        b.append("dataBinding=" + (this.dataBinding == null ? "null" : this.dataBinding));
        b.append(", genericType=" + (this.genericType == null || this.genericType.get() == null ? "null" : this.genericType.get()));
        b.append(", physical=" + (this.physical == null || this.physical.get() == null ? "null" : (Serializable)this.physical.get()));
        b.append(", logical=" + (this.logical == null ? "null" : this.logical));
        b.append(", metaData size=" + (this.metaDataMap == null ? "0" : Integer.valueOf(this.metaDataMap.size())));
        b.append("]");
        return b.toString();
    }
}

