/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceIntrospectorImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaInterfaceFactoryImpl
implements JavaInterfaceFactory {
    private List<JavaInterfaceVisitor> visitors = new ArrayList<JavaInterfaceVisitor>();
    private JavaInterfaceIntrospectorImpl introspector;
    private Map<Class<?>, JavaInterface> cache = Collections.synchronizedMap(new WeakHashMap());

    public JavaInterfaceFactoryImpl() {
        this.introspector = new JavaInterfaceIntrospectorImpl(this);
    }

    @Override
    public JavaInterface createJavaInterface() {
        return new JavaInterfaceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaInterface createJavaInterface(Class<?> interfaceClass) throws InvalidInterfaceException {
        Class<?> clazz = interfaceClass;
        synchronized (clazz) {
            JavaInterface javaInterface = this.cache.get(interfaceClass);
            if (javaInterface == null) {
                javaInterface = this.createJavaInterface();
                this.introspector.introspectInterface(javaInterface, interfaceClass);
                this.cache.put(interfaceClass, javaInterface);
            }
            return javaInterface;
        }
    }

    @Override
    public void createJavaInterface(JavaInterface javaInterface, Class<?> interfaceClass) throws InvalidInterfaceException {
        this.introspector.introspectInterface(javaInterface, interfaceClass);
    }

    @Override
    public JavaInterfaceContract createJavaInterfaceContract() {
        return new JavaInterfaceContractImpl();
    }

    @Override
    public void addInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.add(extension);
    }

    @Override
    public void removeInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.remove(extension);
    }

    @Override
    public List<JavaInterfaceVisitor> getInterfaceVisitors() {
        return this.visitors;
    }
}

