/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidCallbackException;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.InvalidOperationException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.OverloadedOperationException;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaOperationImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.osoa.sca.annotations.Callback;
import org.osoa.sca.annotations.Conversational;
import org.osoa.sca.annotations.EndsConversation;
import org.osoa.sca.annotations.OneWay;
import org.osoa.sca.annotations.Remotable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInterfaceIntrospectorImpl {
    public static final String IDL_INPUT = "idl:input";
    private static final String UNKNOWN_DATABINDING = null;
    private List<JavaInterfaceVisitor> visitors = new ArrayList<JavaInterfaceVisitor>();

    public JavaInterfaceIntrospectorImpl(JavaInterfaceFactory javaFactory) {
        this.visitors = javaFactory.getInterfaceVisitors();
    }

    public void introspectInterface(JavaInterface javaInterface, Class<?> clazz) throws InvalidInterfaceException {
        javaInterface.setJavaClass(clazz);
        boolean remotable = clazz.isAnnotationPresent(Remotable.class);
        if (!remotable) {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!"javax.ejb.Remote".equals(annotation.annotationType().getName())) continue;
                remotable = true;
                break;
            }
        }
        if (!remotable) {
            for (Class<?> superInterface : clazz.getInterfaces()) {
                if (Remote.class != superInterface && !"javax.ejb.EJBObject".equals(superInterface.getName())) continue;
                remotable = true;
                break;
            }
        }
        javaInterface.setRemotable(remotable);
        boolean conversational = clazz.isAnnotationPresent(Conversational.class);
        javaInterface.setConversational(conversational);
        Class<?> callbackClass = null;
        Callback callback = clazz.getAnnotation(Callback.class);
        if (callback != null && !Void.class.equals(callback.value())) {
            callbackClass = callback.value();
            if (remotable && !callbackClass.isAnnotationPresent(Remotable.class)) {
                throw new InvalidCallbackException("Callback must be remotable on a remotable interface");
            }
            if (!remotable && callbackClass.isAnnotationPresent(Remotable.class)) {
                throw new InvalidCallbackException("Callback must not be remotable on a local interface");
            }
        } else if (callback != null && Void.class.equals(callback.value())) {
            throw new InvalidCallbackException("No callback interface specified on annotation");
        }
        javaInterface.setCallbackClass(callbackClass);
        String ns = JavaXMLMapper.getNamespace(clazz);
        javaInterface.getOperations().addAll(this.getOperations(clazz, remotable, conversational, ns));
        for (JavaInterfaceVisitor extension : this.visitors) {
            extension.visitInterface(javaInterface);
        }
    }

    private Class<?>[] getActualTypes(Type[] types, Class<?>[] rawTypes, Map<String, Type> typeBindings) {
        Class[] actualTypes = new Class[types.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            actualTypes[i] = this.getActualType(types[i], rawTypes[i], typeBindings);
        }
        return actualTypes;
    }

    private Class<?> getActualType(Type type, Class<?> rawType, Map<String, Type> typeBindings) {
        TypeVariable typeVariable;
        if (type instanceof TypeVariable && (type = typeBindings.get((typeVariable = (TypeVariable)type).getName())) instanceof Class) {
            return (Class)type;
        }
        return rawType;
    }

    private void collectGenericInterfaces(Class<?> clazz, Set<Type> genericInterfaces) {
        Class<?>[] interfaces;
        for (Type t : clazz.getGenericInterfaces()) {
            genericInterfaces.add(t);
        }
        for (Class<?> c : interfaces = clazz.getInterfaces()) {
            this.collectGenericInterfaces(c, genericInterfaces);
        }
    }

    private <T> List<Operation> getOperations(Class<T> clazz, boolean remotable, boolean conversational, String ns) throws InvalidInterfaceException {
        HashSet<Type> genericInterfaces = new HashSet<Type>();
        this.collectGenericInterfaces(clazz, genericInterfaces);
        HashMap<String, Type> typeBindings = new HashMap<String, Type>();
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            TypeVariable<Class<T>>[] typeVariables = ((Class)parameterizedType.getRawType()).getTypeParameters();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                typeBindings.put(typeVariables[i].getName(), typeArguments[i]);
            }
        }
        Method[] methods = clazz.getMethods();
        ArrayList<Operation> operations = new ArrayList<Operation>(methods.length);
        HashSet<String> names = remotable ? new HashSet<String>() : null;
        for (Method method : methods) {
            if (method.getDeclaringClass() == Object.class) continue;
            String name = method.getName();
            if (remotable && names.contains(name)) {
                throw new OverloadedOperationException(method);
            }
            if (remotable) {
                names.add(name);
            }
            Class<?> returnType = this.getActualType(method.getGenericReturnType(), method.getReturnType(), typeBindings);
            Class<?>[] parameterTypes = this.getActualTypes(method.getGenericParameterTypes(), method.getParameterTypes(), typeBindings);
            Class<?>[] faultTypes = this.getActualTypes(method.getGenericExceptionTypes(), method.getExceptionTypes(), typeBindings);
            boolean nonBlocking = method.isAnnotationPresent(OneWay.class);
            if (nonBlocking) {
                if (returnType != Void.TYPE) {
                    throw new InvalidOperationException("Method should return 'void' when declared with an @OneWay annotation. " + method, method);
                }
                if (faultTypes.length != 0) {
                    throw new InvalidOperationException("Method should not declare exceptions with an @OneWay annotation. " + method, method);
                }
            }
            ConversationSequence conversationSequence = ConversationSequence.CONVERSATION_NONE;
            if (method.isAnnotationPresent(EndsConversation.class)) {
                if (!conversational) {
                    throw new InvalidOperationException("Method is marked as end conversation but contract is not conversational", method);
                }
                conversationSequence = ConversationSequence.CONVERSATION_END;
            } else if (conversational) {
                conversationSequence = ConversationSequence.CONVERSATION_CONTINUE;
            }
            JavaOperationImpl operation = new JavaOperationImpl();
            operation.setName(name);
            XMLType xmlReturnType = new XMLType(new QName(ns, "return"), null);
            DataTypeImpl<XMLType> returnDataType = returnType == Void.TYPE ? null : new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, returnType, method.getGenericReturnType(), xmlReturnType);
            ArrayList<DataTypeImpl<XMLType>> paramDataTypes = new ArrayList<DataTypeImpl<XMLType>>(parameterTypes.length);
            Type[] genericParamTypes = method.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramType = parameterTypes[i];
                XMLType xmlParamType = new XMLType(new QName(ns, "arg" + i), null);
                DataTypeImpl<XMLType> xmlDataType = new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, paramType, genericParamTypes[i], xmlParamType);
                ParameterMode mode = ParameterMode.IN;
                paramDataTypes.add(xmlDataType);
                operation.getParameterModes().add(mode);
            }
            ArrayList<DataType> faultDataTypes = new ArrayList<DataType>(faultTypes.length);
            Type[] genericFaultTypes = method.getGenericExceptionTypes();
            for (int i = 0; i < faultTypes.length; ++i) {
                Class<?> faultType = faultTypes[i];
                if (!Exception.class.isAssignableFrom(faultType) || RuntimeException.class.isAssignableFrom(faultType) || RemoteException.class.isAssignableFrom(faultType)) continue;
                XMLType xmlFaultType = new XMLType(new QName(ns, faultType.getSimpleName()), null);
                DataTypeImpl<XMLType> faultDataType = new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, faultType, genericFaultTypes[i], xmlFaultType);
                faultDataTypes.add(new DataTypeImpl<DataTypeImpl<XMLType>>(UNKNOWN_DATABINDING, faultType, genericFaultTypes[i], faultDataType));
            }
            DataTypeImpl<List<DataType>> inputType = new DataTypeImpl<List<DataType>>(IDL_INPUT, Object[].class, paramDataTypes);
            operation.setInputType(inputType);
            operation.setOutputType(returnDataType);
            operation.setFaultTypes(faultDataTypes);
            operation.setConversationSequence(conversationSequence);
            operation.setNonBlocking(nonBlocking);
            operation.setJavaMethod(method);
            operations.add(operation);
        }
        return operations;
    }
}

