/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.osoa.sca.annotations.PolicySets;
import org.osoa.sca.annotations.Requires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyJavaInterfaceVisitor
implements JavaInterfaceVisitor {
    private PolicyFactory policyFactory;

    public PolicyJavaInterfaceVisitor(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    private QName getQName(String intentName) {
        int i;
        QName qname = intentName.startsWith("{") ? ((i = intentName.indexOf(125)) != -1 ? new QName(intentName.substring(1, i), intentName.substring(i + 1)) : new QName("", intentName)) : new QName("", intentName);
        return qname;
    }

    private void readIntentsAndPolicySets(Class<?> clazz, List<Intent> requiredIntents, List<PolicySet> policySets) {
        String[] policySetNames;
        PolicySets policySetAnnotation;
        String[] intentNames;
        Requires intentAnnotation = clazz.getAnnotation(Requires.class);
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
        if ((policySetAnnotation = clazz.getAnnotation(PolicySets.class)) != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    private void readIntents(Requires intentAnnotation, List<Intent> requiredIntents) {
        String[] intentNames;
        if (intentAnnotation != null && (intentNames = intentAnnotation.value()).length != 0) {
            for (String intentName : intentNames) {
                Intent intent = this.policyFactory.createIntent();
                intent.setName(this.getQName(intentName));
                requiredIntents.add(intent);
            }
        }
    }

    private void readPolicySets(PolicySets policySetAnnotation, List<PolicySet> policySets) {
        String[] policySetNames;
        if (policySetAnnotation != null && (policySetNames = policySetAnnotation.value()).length != 0) {
            for (String policySetName : policySetNames) {
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(this.getQName(policySetName));
                policySets.add(policySet);
            }
        }
    }

    @Override
    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (javaInterface.getJavaClass() != null) {
            this.readIntentsAndPolicySets(javaInterface.getJavaClass(), javaInterface.getRequiredIntents(), javaInterface.getPolicySets());
            List<Operation> operations = javaInterface.getOperations();
            for (Operation op : operations) {
                JavaOperation operation = (JavaOperation)op;
                Method method = operation.getJavaMethod();
                if (method.getAnnotation(Requires.class) == null && method.getAnnotation(PolicySets.class) == null) continue;
                this.readIntents(method.getAnnotation(Requires.class), op.getRequiredIntents());
                this.readPolicySets(method.getAnnotation(PolicySets.class), op.getPolicySets());
            }
        }
    }
}

