/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperInfo {
    private String dataBinding;
    private ElementInfo wrapperElement;
    private List<ElementInfo> childElements;
    private DataType<XMLType> wrapperType;
    private DataType<List<DataType>> unwrappedInputType;
    private DataType<XMLType> unwrappedOutputType;

    public WrapperInfo(String dataBinding, ElementInfo wrapperElement, List<ElementInfo> childElements) {
        this.dataBinding = dataBinding;
        this.wrapperElement = wrapperElement;
        this.childElements = childElements;
    }

    public List<ElementInfo> getChildElements() {
        return this.childElements;
    }

    public ElementInfo getWrapperElement() {
        return this.wrapperElement;
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    public DataType<XMLType> getWrapperType() {
        return this.wrapperType;
    }

    public void setWrapperType(DataType<XMLType> wrapperType) {
        this.wrapperType = wrapperType;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperType == null ? null : this.wrapperType.getPhysical();
    }

    public DataType<List<DataType>> getUnwrappedInputType() {
        if (this.unwrappedInputType == null) {
            ArrayList<DataType> childTypes = new ArrayList<DataType>();
            for (ElementInfo element : this.getChildElements()) {
                DataType type = this.getDataType(element);
                childTypes.add(type);
            }
            this.unwrappedInputType = new DataTypeImpl("idl:unwrapped.input", Object[].class, childTypes);
        }
        return this.unwrappedInputType;
    }

    public DataType getUnwrappedOutputType() {
        List<ElementInfo> elements;
        if (this.unwrappedOutputType == null && (elements = this.getChildElements()) != null && elements.size() > 0) {
            if (elements.size() > 1) {
                // empty if block
            }
            ElementInfo element = elements.get(0);
            this.unwrappedOutputType = this.getDataType(element);
        }
        return this.unwrappedOutputType;
    }

    private DataType getDataType(ElementInfo element) {
        DataTypeImpl<Object> type = null;
        if (element.isMany()) {
            DataTypeImpl<XMLType> logical = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
            type = new DataTypeImpl<DataTypeImpl<XMLType>>("java:array", Object[].class, logical);
        } else {
            type = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
        }
        return type;
    }
}

