/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDocumentProcessor
implements URLArtifactProcessor<WSDLDefinition> {
    public static final QName WSDL11 = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    public static final QName WSDL11_IMPORT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private WSDLFactory factory;
    private XSDFactory xsdFactory;
    private Monitor monitor;

    public WSDLDocumentProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = modelFactories.getFactory(WSDLFactory.class);
        this.xsdFactory = modelFactories.getFactory(XSDFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public WSDLDefinition read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
        try {
            WSDLDefinition definition = this.indexRead(artifactURL);
            definition.setURI(artifactURI);
            return definition;
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", artifactURL, ce);
            return null;
        }
    }

    @Override
    public void resolve(WSDLDefinition model, ModelResolver resolver) throws ContributionResolveException {
        if (model == null) {
            return;
        }
        Definition definition = model.getDefinition();
        if (definition != null) {
            for (Object imports : definition.getImports().values()) {
                List importList = (List)imports;
                for (Object i : importList) {
                    Import imp = (Import)i;
                    if (imp.getDefinition() != null) continue;
                    if (imp.getLocationURI() == null) {
                        WSDLDefinition proxy = this.factory.createWSDLDefinition();
                        proxy.setUnresolved(true);
                        proxy.setNamespace(imp.getNamespaceURI());
                        WSDLDefinition resolved = resolver.resolveModel(WSDLDefinition.class, proxy);
                        if (resolved == null || resolved.isUnresolved()) continue;
                        imp.setDefinition(resolved.getDefinition());
                        if (model.getImportedDefinitions().contains(resolved)) continue;
                        model.getImportedDefinitions().add(resolved);
                        continue;
                    }
                    String location = imp.getLocationURI();
                    URI uri = URI.create(location);
                    if (uri.isAbsolute()) {
                        try {
                            WSDLDefinition resolved = this.read(null, uri, uri.toURL());
                            imp.setDefinition(resolved.getDefinition());
                            if (model.getImportedDefinitions().contains(resolved)) continue;
                            model.getImportedDefinitions().add(resolved);
                        }
                        catch (Exception e) {
                            ContributionResolveException ce = new ContributionResolveException(e);
                            this.error("ContributionResolveException", resolver, ce);
                        }
                        continue;
                    }
                    if (location.startsWith("/")) {
                        location = location.substring(1);
                        continue;
                    }
                    URI baseURI = URI.create(model.getDefinition().getDocumentBaseURI());
                    URI locationURI = baseURI.resolve(location);
                    try {
                        WSDLDefinition resolved = this.read(null, locationURI, locationURI.toURL());
                        imp.setDefinition(resolved.getDefinition());
                        if (model.getImportedDefinitions().contains(resolved)) continue;
                        model.getImportedDefinitions().add(resolved);
                    }
                    catch (Exception e) {
                        ContributionResolveException ce = new ContributionResolveException(e);
                        this.error("ContributionResolveException", resolver, ce);
                    }
                }
            }
        }
    }

    @Override
    public String getArtifactType() {
        return ".wsdl";
    }

    @Override
    public Class<WSDLDefinition> getModelType() {
        return WSDLDefinition.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSDLDefinition indexRead(URL doc) throws Exception {
        WSDLDefinition wsdlDefinition = this.factory.createWSDLDefinition();
        wsdlDefinition.setUnresolved(true);
        wsdlDefinition.setLocation(doc.toURI());
        InputStream is = doc.openStream();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(is);
            int eventType = reader.getEventType();
            int index = 0;
            while (true) {
                if (eventType == 1) {
                    String tns;
                    if (WSDL11.equals(reader.getName())) {
                        tns = reader.getAttributeValue(null, "targetNamespace");
                        wsdlDefinition.setNamespace(tns);
                        wsdlDefinition.setUnresolved(false);
                        wsdlDefinition.setDefinition(null);
                    }
                    if (XSD.equals(reader.getName())) {
                        tns = reader.getAttributeValue(null, "targetNamespace");
                        XSDefinition xsd = this.xsdFactory.createXSDefinition();
                        xsd.setUnresolved(true);
                        xsd.setNamespace(tns);
                        xsd.setLocation(URI.create(doc.toURI() + "#" + index));
                        ++index;
                        xsd.setUnresolved(false);
                        xsd.setSchema(null);
                        wsdlDefinition.getXmlSchemas().add(xsd);
                    }
                }
                if (!reader.hasNext()) break;
                eventType = reader.next();
            }
            WSDLDefinition wSDLDefinition = wsdlDefinition;
            return wSDLDefinition;
        }
        finally {
            is.close();
        }
    }
}

