/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import com.ibm.wsdl.OperationImpl;
import java.util.List;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.WSDLConstants;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLInterfaceProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WSDLInterfaceContract>,
WSDLConstants {
    private WSDLFactory wsdlFactory;
    private ExtensionFactory extensionFactory;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private Monitor monitor;

    public WSDLInterfaceProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.extensionFactory = modelFactories.getFactory(ExtensionFactory.class);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.monitor = monitor;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private WSDLInterface createWSDLInterface(String uri) throws ContributionReadException {
        WSDLInterface wsdlInterface = null;
        int index = uri.indexOf(35);
        if (index == -1) {
            this.error("InvalidWSDLInterfaceAttr", (Object)this.wsdlFactory, uri);
        } else {
            wsdlInterface = this.wsdlFactory.createWSDLInterface();
            wsdlInterface.setUnresolved(true);
            String namespace = uri.substring(0, index);
            String name = uri.substring(index + 1);
            name = name.substring("wsdl.interface(".length(), name.length() - 1);
            wsdlInterface.setName(new QName(namespace, name));
        }
        return wsdlInterface;
    }

    @Override
    public WSDLInterfaceContract read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        WSDLInterface wsdlCallbackInterface;
        WSDLInterface wsdlInterface;
        WSDLInterfaceContract wsdlInterfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        String location = reader.getAttributeValue("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation");
        wsdlInterfaceContract.setLocation(location);
        String uri = WSDLInterfaceProcessor.getURIString(reader, "interface");
        if (uri != null && (wsdlInterface = this.createWSDLInterface(uri)) != null) {
            wsdlInterfaceContract.setInterface(wsdlInterface);
        }
        if ((uri = WSDLInterfaceProcessor.getURIString(reader, "callbackInterface")) != null && (wsdlCallbackInterface = this.createWSDLInterface(uri)) != null) {
            wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
        }
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || "http://www.osoa.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI()) || "http://tuscany.apache.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : this.extensionFactory.createExtension(attributeName, attributeValue, true);
            wsdlInterfaceContract.getAttributeExtensions().add(attributeExtension);
        }
        while (reader.hasNext() && (reader.next() != 2 || !INTERFACE_WSDL_QNAME.equals(reader.getName()))) {
        }
        return wsdlInterfaceContract;
    }

    @Override
    public void write(WSDLInterfaceContract wsdlInterfaceContract, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        WSDLInterface wsdlCallbackInterface;
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "interface.wsdl");
        WSDLInterface wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface();
        if (wsdlInterface != null) {
            QName qname = wsdlInterface.getName();
            String uri = qname.getNamespaceURI() + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("interface", uri);
        }
        if ((wsdlCallbackInterface = (WSDLInterface)wsdlInterfaceContract.getCallbackInterface()) != null) {
            QName qname = wsdlCallbackInterface.getName();
            String uri = qname.getNamespaceURI() + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("callbackInterface", uri);
        }
        if (wsdlInterfaceContract.getLocation() != null) {
            writer.writeAttribute("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation", wsdlInterfaceContract.getLocation());
        }
        for (Extension extension : wsdlInterfaceContract.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write(extension, writer);
        }
        writer.writeEndElement();
    }

    private WSDLInterface resolveWSDLInterface(WSDLInterface wsdlInterface, ModelResolver resolver) throws ContributionResolveException {
        if (wsdlInterface != null && wsdlInterface.isUnresolved() && (wsdlInterface = resolver.resolveModel(WSDLInterface.class, wsdlInterface)).isUnresolved()) {
            WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
            wsdlDefinition.setUnresolved(true);
            wsdlDefinition.setNamespace(wsdlInterface.getName().getNamespaceURI());
            WSDLDefinition resolved = null;
            try {
                resolved = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition);
            }
            catch (ContributionRuntimeException e) {
                ContributionResolveException ce = new ContributionResolveException(e.getCause());
                this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
            }
            if (resolved != null && !resolved.isUnresolved()) {
                wsdlDefinition.setDefinition(resolved.getDefinition());
                wsdlDefinition.setLocation(resolved.getLocation());
                wsdlDefinition.setURI(resolved.getURI());
                wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
                wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
                wsdlDefinition.setUnresolved(false);
                WSDLObject<PortType> portType = wsdlDefinition.getWSDLObject(PortType.class, wsdlInterface.getName());
                if (portType != null) {
                    ContributionResolveException ce;
                    List operations = portType.getElement().getOperations();
                    for (OperationImpl operation : operations) {
                        ContributionResolveException ce2;
                        if (operation.getInput() != null && operation.getInput().getMessage() == null) {
                            ce2 = new ContributionResolveException("WSDL binding operation input name " + operation.getInput().getName() + " does not match with PortType Definition");
                            this.error("ContributionResolveException", (Object)wsdlDefinition, ce2);
                        }
                        if (operation.getOutput() == null || operation.getOutput().getMessage() != null) continue;
                        ce2 = new ContributionResolveException("WSDL binding operation output name " + operation.getOutput().getName() + " does not match with PortType Definition");
                        this.error("ContributionResolveException", (Object)wsdlDefinition, ce2);
                    }
                    try {
                        wsdlDefinition.setDefinition(portType.getDefinition());
                        wsdlInterface = this.wsdlFactory.createWSDLInterface(portType.getElement(), wsdlDefinition, resolver);
                        wsdlInterface.setWsdlDefinition(wsdlDefinition);
                        resolver.addModel(wsdlInterface);
                    }
                    catch (ContributionRuntimeException e) {
                        ce = new ContributionResolveException(e.getCause());
                        this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
                    }
                    catch (InvalidInterfaceException e) {
                        ce = new ContributionResolveException(e);
                        this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
                    }
                } else {
                    this.warning("WsdlInterfaceDoesNotMatch", wsdlDefinition, wsdlInterface.getName());
                }
            }
        }
        return wsdlInterface;
    }

    @Override
    public void resolve(WSDLInterfaceContract wsdlInterfaceContract, ModelResolver resolver) throws ContributionResolveException {
        WSDLInterface wsdlInterface = this.resolveWSDLInterface((WSDLInterface)wsdlInterfaceContract.getInterface(), resolver);
        wsdlInterfaceContract.setInterface(wsdlInterface);
        WSDLInterface wsdlCallbackInterface = this.resolveWSDLInterface((WSDLInterface)wsdlInterfaceContract.getCallbackInterface(), resolver);
        wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
    }

    @Override
    public QName getArtifactType() {
        return WSDLConstants.INTERFACE_WSDL_QNAME;
    }

    @Override
    public Class<WSDLInterfaceContract> getModelType() {
        return WSDLInterfaceContract.class;
    }
}

