/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainManagerLauncher {
    static final Logger logger = Logger.getLogger(DomainManagerLauncher.class.getName());

    private DomainManagerLauncher() {
    }

    public static DomainManagerLauncher newInstance() {
        return new DomainManagerLauncher();
    }

    public <T> T createDomainManager() throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(".");
    }

    public <T> T createDomainManager(String rootDirectory) throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(rootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block18: {
            logger.info("Apache Tuscany SCA Domain Manager is starting...");
            DomainManagerLauncher launcher = DomainManagerLauncher.newInstance();
            String rootDirectory = ".";
            if (args.length > 0) {
                rootDirectory = args[0];
            }
            Object domainManager = null;
            ShutdownThread shutdown = null;
            try {
                int k;
                do {
                    domainManager = launcher.createDomainManager(rootDirectory);
                    try {
                        domainManager.getClass().getMethod("start", new Class[0]).invoke(domainManager, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "SCA Domain Manager could not be started", e);
                        throw e;
                    }
                    logger.info("SCA Domain Manager is now started.");
                    shutdown = new ShutdownThread(domainManager);
                    Runtime.getRuntime().addShutdownHook(shutdown);
                    logger.info("Press 'q' to quit, 'r' to restart.");
                    k = 0;
                    try {
                        while (k != 113 && k != 114) {
                            k = System.in.read();
                        }
                    }
                    catch (IOException e) {
                        Object lock;
                        Object object = lock = new Object();
                        synchronized (object) {
                            lock.wait();
                        }
                    }
                    if (domainManager == null) continue;
                    Object dm = domainManager;
                    domainManager = null;
                    DomainManagerLauncher.stopDomainManager(dm);
                } while (k != 113);
                if (shutdown == null) break block18;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Exception e) {
                try {
                    if (domainManager != null) {
                        try {
                            Object dm = domainManager;
                            domainManager = null;
                            DomainManagerLauncher.stopDomainManager(dm);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (shutdown != null) {
                        Runtime.getRuntime().removeShutdownHook(shutdown);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static void stopDomainManager(Object domainManager) throws Exception {
        try {
            domainManager.getClass().getMethod("stop", new Class[0]).invoke(domainManager, new Object[0]);
            logger.info("SCA Domain Manager is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Domain Manager could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object domainManager;

        public ShutdownThread(Object domainManager) {
            this.domainManager = domainManager;
        }

        public void run() {
            try {
                DomainManagerLauncher.stopDomainManager(this.domainManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

