/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.Contribution;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLauncher {
    static final Logger logger = Logger.getLogger(NodeLauncher.class.getName());

    private NodeLauncher() {
    }

    public static NodeLauncher newInstance() {
        return new NodeLauncher();
    }

    public <T> T createNodeFromURL(String configurationURL) throws LauncherException {
        return (T)NodeLauncherUtil.node(configurationURL, null, null, null, null);
    }

    public <T> T createNode(String compositeURI, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, null, contributions, null);
    }

    public <T> T createNode(String compositeURI, String compositeContent, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, compositeContent, contributions, null);
    }

    public <T> T createNodeFromClassLoader(String compositeURI, ClassLoader classLoader) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, null, null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block22: {
            logger.info("Apache Tuscany SCA Node is starting...");
            NodeLauncher launcher = NodeLauncher.newInstance();
            Object node = null;
            ShutdownThread shutdown = null;
            try {
                int k;
                do {
                    if (args.length == 1) {
                        String configurationURI = args[0];
                        logger.info("SCA Node configuration: " + configurationURI);
                        node = launcher.createNodeFromURL(configurationURI);
                    } else {
                        String compositeURI = args[0];
                        if ("-".equals(compositeURI)) {
                            compositeURI = null;
                        } else {
                            logger.info("SCA composite: " + compositeURI);
                        }
                        Contribution[] contributions = new Contribution[args.length - 1];
                        for (int i = 1; i < args.length; ++i) {
                            String contributionLocation = args[i];
                            logger.info("SCA contribution: " + contributionLocation);
                            contributions[i - 1] = new Contribution("contribution" + (i - 1), contributionLocation);
                        }
                        node = launcher.createNode(compositeURI, contributions);
                    }
                    try {
                        node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "SCA Node could not be started", e);
                        throw e;
                    }
                    logger.info("SCA Node is now started.");
                    shutdown = new ShutdownThread(node);
                    Runtime.getRuntime().addShutdownHook(shutdown);
                    logger.info("Press 'q' to quit, 'r' to restart.");
                    k = 0;
                    try {
                        while (k != 113 && k != 114) {
                            k = System.in.read();
                        }
                    }
                    catch (IOException e) {
                        Object lock;
                        Object object = lock = new Object();
                        synchronized (object) {
                            lock.wait();
                        }
                    }
                    if (node == null) continue;
                    Object n = node;
                    node = null;
                    NodeLauncher.stopNode(n);
                } while (k != 113);
                if (shutdown == null) break block22;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Exception e) {
                try {
                    if (node != null) {
                        try {
                            Object n = node;
                            node = null;
                            NodeLauncher.stopNode(n);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (shutdown != null) {
                        Runtime.getRuntime().removeShutdownHook(shutdown);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static void stopNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object node;

        public ShutdownThread(Object node) {
            this.node = node;
        }

        public void run() {
            try {
                NodeLauncher.stopNode(this.node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

