/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.osgi.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.BundleContext;

public class EquinoxRuntime
extends OSGiRuntime {
    private static BundleContext bundleContext;
    private static EquinoxRuntime instance;
    private static Class<?> eclipseStarterClass;

    public static OSGiRuntime getInstance() throws Exception {
        if (instance == null) {
            EquinoxRuntime runtime;
            eclipseStarterClass = EquinoxRuntime.class.getClassLoader().loadClass("org.eclipse.core.runtime.adaptor.EclipseStarter");
            instance = runtime = new EquinoxRuntime();
        }
        return instance;
    }

    protected BundleContext startRuntime(boolean tuscanyRunningInOSGiContainer) throws Exception {
        if (bundleContext != null) {
            return bundleContext;
        }
        Method startupMethod = eclipseStarterClass.getMethod("startup", String[].class, Runnable.class);
        if (startupMethod.getReturnType() == BundleContext.class) {
            bundleContext = (BundleContext)startupMethod.invoke(null, new Object[]{new String[]{"-clean", "-console"}, null});
        } else {
            Method mainMethod = eclipseStarterClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{new String[]{"-clean", "-console"}});
            Field contextField = eclipseStarterClass.getDeclaredField("context");
            contextField.setAccessible(true);
            bundleContext = (BundleContext)contextField.get(null);
        }
        return bundleContext;
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        EquinoxRuntime.bundleContext = bundleContext;
    }

    public void shutdown() throws Exception {
        if (bundleContext == null) {
            return;
        }
        bundleContext = null;
        instance = null;
        if (eclipseStarterClass != null) {
            Method shutdownMethod = eclipseStarterClass.getMethod("shutdown", new Class[0]);
            try {
                shutdownMethod.invoke(eclipseStarterClass, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.shutdown();
    }

    public boolean supportsBundleFragments() {
        return false;
    }
}

