/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.osgi.runtime;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class FelixRuntime
extends OSGiRuntime
implements BundleActivator {
    private static BundleContext bundleContext;
    private static FelixRuntime instance;
    private static Class<?> felixMainClass;
    private static Class<?> felixClass;
    private static Object felix;

    public static OSGiRuntime getInstance() throws Exception {
        if (instance == null) {
            FelixRuntime runtime;
            felixMainClass = FelixRuntime.class.getClassLoader().loadClass("org.apache.felix.main.Main");
            instance = runtime = new FelixRuntime();
        }
        return instance;
    }

    private static void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FelixRuntime.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContext startRuntime(boolean tuscanyRunningInOSGiContainer) throws Exception {
        File profileDir;
        if (bundleContext != null) {
            return bundleContext;
        }
        ClassLoader cl = FelixRuntime.class.getClassLoader();
        felixClass = cl.loadClass("org.apache.felix.framework.Felix");
        Method propsMethod = felixMainClass.getMethod("loadConfigProperties", new Class[0]);
        Properties props = (Properties)propsMethod.invoke(null, new Object[0]);
        String profileDirName = ".felix";
        File targetDir = new File("target");
        if (targetDir.exists() && targetDir.isDirectory()) {
            profileDirName = "target/" + profileDirName;
        }
        if ((profileDir = new File(profileDirName)).isDirectory()) {
            FelixRuntime.deleteDirectory(profileDir);
        } else {
            profileDir.delete();
        }
        profileDir.mkdir();
        profileDir.deleteOnExit();
        props.put("felix.cache.profiledir", profileDir.getAbsolutePath());
        props.put("felix.embedded.execution", "true");
        String systemPackages = "org.osgi.framework; version=1.3.0,org.osgi.service.packageadmin; version=1.2.0, org.osgi.service.startlevel; version=1.0.0, org.osgi.service.url; version=1.0.0, org.osgi.util.tracker; version=1.3.2, javax.xml, javax.xml.datatype, javax.xml.namespace, javax.xml.parsers, javax.xml.transform, javax.xml.transform.dom, javax.xml.transform.sax, javax.xml.transform.stream, javax.xml.validation, javax.xml.xpath, org.apache.xerces.jaxp.datatype, org.w3c.dom, org.xml.sax, org.xml.sax.ext, org.xml.sax.helpers, javax.security.auth, javax.naming, javax.naming.spi, javax.naming.directory, javax.management, sun.misc";
        if (!tuscanyRunningInOSGiContainer) {
            systemPackages = systemPackages + ", org.osoa.sca.annotations, org.osoa.sca";
            systemPackages = systemPackages + ", commonj.sdo, commonj.sdo.helper, org.apache.tuscany.sdo.helper, org.apache.tuscany.sdo.impl, org.apache.tuscany.sdo.model, org.apache.tuscany.sdo.model.impl";
            systemPackages = systemPackages + ", org.eclipse.emf.ecore, org.eclipse.emf.ecore.util, org.eclipse.emf.ecore.impl";
        }
        props.put("org.osgi.framework.system.packages", systemPackages);
        try {
            Constructor<?> felixConstructor = felixClass.getConstructor(Map.class, List.class);
            ArrayList<BundleActivator> activators = new ArrayList<BundleActivator>();
            Class<?> autoActivatorClass = cl.loadClass("org.apache.felix.main.AutoActivator");
            Constructor<?> autoActivatorConstructor = autoActivatorClass.getConstructor(Map.class);
            BundleActivator autoActivator = (BundleActivator)autoActivatorConstructor.newInstance(props);
            activators.add(autoActivator);
            felix = felixConstructor.newInstance(props, activators);
            ((Bundle)felix).start();
            bundleContext = ((Bundle)felix).getBundleContext();
        }
        catch (Exception e) {
            Class<?> propertyResolverClass = cl.loadClass("org.apache.felix.framework.util.MutablePropertyResolver");
            Class<?> propertyResolverImplClass = cl.loadClass("org.apache.felix.framework.util.MutablePropertyResolverImpl");
            Constructor<?> implConstructor = propertyResolverImplClass.getConstructor(Map.class);
            Object mutableProps = implConstructor.newInstance(props);
            try {
                Constructor<?> felixConstructor = felixClass.getConstructor(propertyResolverClass, List.class);
                ArrayList activators = new ArrayList();
                felix = felixConstructor.newInstance(mutableProps, activators);
                ((Bundle)felix).start();
                bundleContext = ((Bundle)felix).getBundleContext();
            }
            catch (Exception e1) {
                felix = felixClass.newInstance();
                Method startMethod = felixClass.getMethod("start", propertyResolverClass, List.class);
                ArrayList<FelixRuntime> activators = new ArrayList<FelixRuntime>();
                FelixRuntime activator = new FelixRuntime();
                activators.add(activator);
                startMethod.invoke(felix, mutableProps, activators);
                FelixRuntime felixRuntime = activator;
                synchronized (felixRuntime) {
                    int retries = 0;
                    while (bundleContext == null && retries++ < 10) {
                        activator.wait(1000L);
                    }
                }
            }
        }
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        FelixRuntime felixRuntime = this;
        synchronized (felixRuntime) {
            this.notify();
        }
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        FelixRuntime.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        if (bundleContext == null) {
            return;
        }
        bundleContext = null;
        instance = null;
        if (felix instanceof Bundle) {
            Bundle felixBundle = (Bundle)felix;
            felixBundle.stop();
            int retries = 50;
            Object object = felix;
            synchronized (object) {
                while (retries-- > 0 && felixBundle.getState() != 1) {
                    felix.wait(100L);
                }
            }
        }
        if (felix != null) {
            Method shutdownMethod = felixClass.getMethod("shutdown", new Class[0]);
            try {
                shutdownMethod.invoke(felix, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            felix = null;
        }
        super.shutdown();
    }

    public boolean supportsBundleFragments() {
        return false;
    }
}

