/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.osgi.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class KnopflerfishRuntime
extends OSGiRuntime {
    private static BundleContext bundleContext;
    private static KnopflerfishRuntime instance;
    private static Class<?> frameworkClass;
    private static Object framework;

    public static OSGiRuntime getInstance() throws Exception {
        if (instance == null) {
            KnopflerfishRuntime runtime;
            frameworkClass = KnopflerfishRuntime.class.getClassLoader().loadClass("org.knopflerfish.framework.Framework");
            instance = runtime = new KnopflerfishRuntime();
        }
        return instance;
    }

    protected BundleContext startRuntime(boolean tuscanyRunningInOSGiContainer) throws Exception {
        if (bundleContext != null) {
            return bundleContext;
        }
        System.setProperty("org.knopflerfish.framework.bundlestorage", "memory");
        Constructor<?> frameworkConstructor = frameworkClass.getConstructor(Object.class);
        framework = frameworkConstructor.newInstance(new KnopflerfishRuntime());
        Method launchMethod = frameworkClass.getMethod("launch", Long.TYPE);
        launchMethod.invoke(framework, 0);
        Method getContextMethod = frameworkClass.getMethod("getSystemBundleContext", new Class[0]);
        bundleContext = (BundleContext)getContextMethod.invoke(framework, new Object[0]);
        System.setProperty("com.gatespace.bundle.cm.store", "knopflerfish.store");
        File xargsFile = null;
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(System.getProperty("path.separator"));
        for (int i = 0; i < classpathEntries.length; ++i) {
            if (!classpathEntries[i].endsWith("framework.jar")) continue;
            String path = classpathEntries[i].substring(0, classpathEntries[i].length() - "framework.jar".length());
            xargsFile = new File(path = path + "sca.xargs");
            if (xargsFile.exists()) break;
            xargsFile = null;
            break;
        }
        if (xargsFile != null) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(xargsFile));
            Hashtable<String, Bundle> bundles = new Hashtable<String, Bundle>();
            while ((line = reader.readLine()) != null) {
                Bundle bundle;
                String bundleLocation;
                if ((line = line.trim()).startsWith("-install")) {
                    try {
                        bundleLocation = line.substring("-install".length()).trim();
                        bundle = bundleContext.installBundle(bundleLocation);
                        bundles.put(bundleLocation, bundle);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                if (!line.startsWith("-start")) continue;
                try {
                    bundleLocation = line.substring("-start".length()).trim();
                    bundle = (Bundle)bundles.get(bundleLocation);
                    bundle.start();
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
        }
        return bundleContext;
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        KnopflerfishRuntime.bundleContext = bundleContext;
    }

    public void shutdown() throws Exception {
        if (bundleContext == null) {
            return;
        }
        bundleContext = null;
        instance = null;
        if (framework != null) {
            Method shutdownMethod = frameworkClass.getMethod("shutdown", new Class[0]);
            try {
                shutdownMethod.invoke(framework, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            framework = null;
        }
        super.shutdown();
    }

    public boolean supportsBundleFragments() {
        return true;
    }
}

