/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.osgi.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.extensibility.osgi.OSGiServiceDiscoverer;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class OSGiBundleActivator
implements BundleActivator,
BundleListener {
    private static final String TUSCANY_SCA_BUNDLE_PREFIX = "org.apache.tuscany.sca";
    private static final String TUSCANY_3RD_PARTY_BUNDLE_PREFIX = "org.apache.tuscany.sca.3rdparty";
    private OSGiRuntime runtime;
    private BundleClassLoader threadContextClassLoader;
    private ClassLoader origTCCL;
    private Bundle thisBundle;

    public void start(BundleContext bundleContext) throws Exception {
        this.initializeTuscanyClassLoaders(bundleContext);
        this.runtime = OSGiRuntime.findRuntime();
        this.runtime.setBundleContext(bundleContext);
        this.runtime.setContextClassLoader(this.threadContextClassLoader);
        this.runtime.initialize();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (Thread.currentThread().getContextClassLoader() == this.threadContextClassLoader) {
            Thread.currentThread().setContextClassLoader(this.origTCCL);
        }
    }

    private void initializeTuscanyClassLoaders(BundleContext bundleContext) {
        Bundle[] bundles;
        OSGiServiceDiscoverer discoverer = new OSGiServiceDiscoverer(bundleContext);
        ServiceDiscovery.getInstance().setServiceDiscoverer(discoverer);
        this.thisBundle = bundleContext.getBundle();
        this.origTCCL = Thread.currentThread().getContextClassLoader();
        this.threadContextClassLoader = new BundleClassLoader(this.thisBundle, this.origTCCL);
        Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
        BundleClassLoader cl = new BundleClassLoader(this.thisBundle, null);
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            this.updateBundleClassLoader(bundle);
        }
        bundleContext.addBundleListener((BundleListener)this);
    }

    private void updateBundleClassLoader(Bundle bundle) {
        if (bundle.getSymbolicName().startsWith(TUSCANY_SCA_BUNDLE_PREFIX)) {
            if (bundle.getSymbolicName().startsWith(TUSCANY_3RD_PARTY_BUNDLE_PREFIX)) {
                this.threadContextClassLoader.addBundle(bundle);
            } else {
                String thisBundleVersion = (String)this.thisBundle.getHeaders().get("Bundle-Version");
                String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
                if ((thisBundleVersion == null || bundleVersion == null || thisBundleVersion.equals(bundleVersion)) && !this.threadContextClassLoader.bundles.contains(bundle)) {
                    BundleClassLoader cl = new BundleClassLoader(bundle, null);
                    this.threadContextClassLoader.addBundle(bundle);
                }
            }
        } else {
            this.threadContextClassLoader.addBundle(bundle);
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (event.getType() == 16) {
            this.threadContextClassLoader.removeBundle(bundle);
        } else if (event.getType() == 1) {
            this.updateBundleClassLoader(bundle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleClassLoader
    extends ClassLoader {
        private HashSet<Bundle> bundles = new HashSet();

        BundleClassLoader(Bundle bundle, ClassLoader parent) {
            super(parent);
            this.bundles.add(bundle);
        }

        private synchronized void addBundle(Bundle bundle) {
            this.bundles.add(bundle);
        }

        private synchronized void removeBundle(Bundle bundle) {
            if (this.bundles.contains(bundle)) {
                this.bundles.remove(bundle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            Class clazz = null;
            BundleClassLoader bundleClassLoader = this;
            synchronized (bundleClassLoader) {
                for (Bundle bundle : this.bundles) {
                    try {
                        clazz = bundle.loadClass(className);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (NoClassDefFoundError e) {
                    }
                }
            }
            if (clazz != null) {
                return clazz;
            }
            return super.findClass(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Enumeration<URL> getResources(String resName) throws IOException {
            HashSet urlSet = new HashSet();
            Enumeration urls = null;
            BundleClassLoader bundleClassLoader = this;
            synchronized (bundleClassLoader) {
                for (Bundle bundle : this.bundles) {
                    urls = bundle.getResources(resName);
                    if (urls == null) continue;
                    while (urls.hasMoreElements()) {
                        urlSet.add(urls.nextElement());
                    }
                }
            }
            if (urlSet.size() > 0) {
                return Collections.enumeration(urlSet);
            }
            return super.getResources(resName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getResource(String resName) {
            URL url = null;
            BundleClassLoader bundleClassLoader = this;
            synchronized (bundleClassLoader) {
                for (Bundle bundle : this.bundles) {
                    url = bundle.getResource(resName);
                    if (url == null) continue;
                    return url;
                }
            }
            return super.getResource(resName);
        }

        public String toString() {
            return "Tuscany BundleClassLoader " + this.bundles.iterator().next();
        }
    }
}

