/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.host.http.UserContext;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.authentication.AuthenticationConfigurationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationConfigurationPolicyProcessor
implements StAXArtifactProcessor<AuthenticationConfigurationPolicy> {
    private static final QName AUTHENTICATION_CONFIGURATION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "authenticationConfiguration");
    private static final QName USER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "user");
    private Monitor monitor;

    public AuthenticationConfigurationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-http-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return AuthenticationConfigurationPolicy.NAME;
    }

    @Override
    public Class<AuthenticationConfigurationPolicy> getModelType() {
        return AuthenticationConfigurationPolicy.class;
    }

    @Override
    public AuthenticationConfigurationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        AuthenticationConfigurationPolicy authenticationConfiguration = new AuthenticationConfigurationPolicy();
        int event = reader.getEventType();
        QName start = reader.getName();
        QName name = null;
        while (true) {
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!USER_QNAME.equals(name)) break;
                    UserContext user = new UserContext();
                    String username = reader.getAttributeValue(null, "username");
                    if (username == null) {
                        this.error("RequiredAttributeUsernameMissing", reader, new Object[0]);
                    } else {
                        user.setUsername(username);
                    }
                    String password = reader.getAttributeValue(null, "password");
                    if (password == null) {
                        this.error("RequiredAttributePasswordMissing", reader, new Object[0]);
                    } else {
                        user.setPassword(password);
                    }
                    String roles = reader.getAttributeValue(null, "roles");
                    if (roles == null) {
                        this.error("RequiredAttributeRolesMissing", reader, new Object[0]);
                    } else {
                        StringTokenizer tokens = new StringTokenizer(roles, ",");
                        while (tokens.hasMoreTokens()) {
                            user.getRoles().add(tokens.nextToken());
                        }
                    }
                    authenticationConfiguration.getUsers().add(user);
                    break;
                }
                case 2: {
                    if (!start.equals(reader.getName())) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return authenticationConfiguration;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return authenticationConfiguration;
    }

    @Override
    public void write(AuthenticationConfigurationPolicy model, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    public void resolve(AuthenticationConfigurationPolicy model, ModelResolver resolver) throws ContributionResolveException {
    }
}

