/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationReferencePolicyInterceptor;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class BasicAuthenticationReferencePolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private Binding binding;

    public BasicAuthenticationReferencePolicyProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        this.component = component;
        this.reference = reference;
        this.binding = binding;
    }

    private PolicySet findPolicySet() {
        if (this.binding instanceof PolicySetAttachPoint) {
            List<PolicySet> policySets = ((PolicySetAttachPoint)((Object)this.binding)).getApplicablePolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!BasicAuthenticationPolicy.class.isInstance(p)) continue;
                    return ps;
                }
            }
        }
        return null;
    }

    private String getContext() {
        return "component.reference: " + this.component.getURI() + "#" + this.reference.getName() + "(" + this.binding.getClass().getName() + ")";
    }

    public Interceptor createInterceptor(Operation operation) {
        PolicySet ps = this.findPolicySet();
        return ps == null ? null : new BasicAuthenticationReferencePolicyInterceptor(this.getContext(), operation, ps);
    }

    public String getPhase() {
        return "reference.policy";
    }
}

