/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authorization;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.authorization.AuthorizationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationPolicyProcessor
implements StAXArtifactProcessor<AuthorizationPolicy> {
    private static final String ROLES = "roles";
    private Monitor monitor;

    @Override
    public QName getArtifactType() {
        return AuthorizationPolicy.NAME;
    }

    public AuthorizationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public AuthorizationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        AuthorizationPolicy policy = new AuthorizationPolicy();
        int event = reader.getEventType();
        QName start = reader.getName();
        while (true) {
            switch (event) {
                case 1: {
                    String ac = reader.getName().getLocalPart();
                    if ("allow".equals(ac)) {
                        policy.setAccessControl(AuthorizationPolicy.AcessControl.allow);
                        String roleNames = reader.getAttributeValue(null, ROLES);
                        if (roleNames == null) {
                            this.error("RequiredAttributeRolesMissing", reader, new Object[0]);
                            break;
                        }
                        StringTokenizer st = new StringTokenizer(roleNames);
                        while (st.hasMoreTokens()) {
                            policy.getRoleNames().add(st.nextToken());
                        }
                        break;
                    }
                    if ("permitAll".equals(ac)) {
                        policy.setAccessControl(AuthorizationPolicy.AcessControl.permitAll);
                        break;
                    }
                    if (!"denyAll".endsWith(ac)) break;
                    policy.setAccessControl(AuthorizationPolicy.AcessControl.denyAll);
                    break;
                }
                case 2: {
                    if (!start.equals(reader.getName())) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return policy;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return policy;
    }

    @Override
    public void write(AuthorizationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(AuthorizationPolicy.NAME.getLocalPart());
        writer.writeStartElement(policy.getAccessControl().name());
        if (policy.getAccessControl() == AuthorizationPolicy.AcessControl.allow) {
            StringBuffer sb = new StringBuffer();
            for (String role : policy.getRoleNames()) {
                sb.append(role);
            }
            if (sb.length() > 0) {
                writer.writeAttribute(ROLES, sb.toString());
            }
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public Class<AuthorizationPolicy> getModelType() {
        return AuthorizationPolicy.class;
    }

    @Override
    public void resolve(AuthorizationPolicy policy, ModelResolver resolver) throws ContributionResolveException {
        if (policy.getAccessControl() == AuthorizationPolicy.AcessControl.allow && policy.getRoleNames().isEmpty()) {
            return;
        }
        policy.setUnresolved(false);
    }
}

