/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.confidentiality;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.confidentiality.ConfidentialityPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfidentialityPolicyProcessor
implements StAXArtifactProcessor<ConfidentialityPolicy> {
    private static final QName KEY_STORE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "keyStore");
    private static final QName TRUST_STORE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "trustStore");
    private Monitor monitor;

    public ConfidentialityPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-http-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return ConfidentialityPolicy.NAME;
    }

    @Override
    public Class<ConfidentialityPolicy> getModelType() {
        return ConfidentialityPolicy.class;
    }

    @Override
    public ConfidentialityPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ConfidentialityPolicy policy = new ConfidentialityPolicy();
        int event = reader.getEventType();
        QName start = reader.getName();
        QName name = null;
        while (true) {
            switch (event) {
                case 1: {
                    String password;
                    String file;
                    String type;
                    name = reader.getName();
                    if (KEY_STORE_QNAME.equals(name)) {
                        type = reader.getAttributeValue(null, "type");
                        if (type == null) {
                            this.error("RequiredAttributeKeyStoreTypeMissing", reader, new Object[0]);
                        } else {
                            policy.setKeyStoreType(type);
                        }
                        file = reader.getAttributeValue(null, "file");
                        if (file == null) {
                            this.error("RequiredAttributeKeyStoreFileMissing", reader, new Object[0]);
                        } else {
                            policy.setKeyStore(file);
                        }
                        password = reader.getAttributeValue(null, "password");
                        if (file == null) {
                            this.error("RequiredAttributeKeyStorePasswordMissing", reader, new Object[0]);
                            break;
                        }
                        policy.setKeyStorePassword(password);
                        break;
                    }
                    if (!TRUST_STORE_QNAME.equals(name)) break;
                    type = reader.getAttributeValue(null, "type");
                    if (type == null) {
                        this.error("RequiredAttributeTrustStoreTypeMissing", reader, new Object[0]);
                    } else {
                        policy.setTrustStoreType(type);
                    }
                    file = reader.getAttributeValue(null, "file");
                    if (file == null) {
                        this.error("RequiredAttributeTrusStoreFileMissing", reader, new Object[0]);
                    } else {
                        policy.setTrustStore(file);
                    }
                    password = reader.getAttributeValue(null, "password");
                    if (file == null) {
                        this.error("RequiredAttributeTrustStorePasswordMissing", reader, new Object[0]);
                        break;
                    }
                    policy.setTrustStorePassword(password);
                    break;
                }
                case 2: {
                    if (!start.equals(reader.getName())) break;
                    if (reader.hasNext()) {
                        reader.next();
                    }
                    return policy;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return policy;
    }

    @Override
    public void write(ConfidentialityPolicy model, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    public void resolve(ConfidentialityPolicy model, ModelResolver resolver) throws ContributionResolveException {
    }
}

