/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.geronimo;

import java.security.AccessControlContext;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.geronimo.security.ContextManager;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.authorization.AuthorizationPolicy;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationCallbackHandler;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationPolicy;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandler;
import org.apache.tuscany.sca.policy.security.http.util.HttpSecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoLDAPSecurityHandler
implements LDAPSecurityHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleSecurity(Message msg, List<LDAPRealmAuthenticationPolicy> authenticationPolicies, List<AuthorizationPolicy> authorizationPolicies) throws LoginException {
        AuthorizationPolicy authorizationPolicy;
        Subject subject = null;
        Subject authenticatedSubject = null;
        LDAPRealmAuthenticationPolicy authenticationPolicy = authenticationPolicies.get(0);
        if (authenticationPolicy != null) {
            subject = HttpSecurityUtil.getSubject(msg);
            LDAPRealmAuthenticationCallbackHandler callbackHandler = new LDAPRealmAuthenticationCallbackHandler(subject);
            try {
                LoginContext geronimoLoginContext = ContextManager.login((String)authenticationPolicy.getRealmConfigurationName(), (CallbackHandler)callbackHandler);
                authenticatedSubject = geronimoLoginContext.getSubject();
                ContextManager.setCallers((Subject)authenticatedSubject, (Subject)authenticatedSubject);
                if (authenticatedSubject == null) {
                    // empty if block
                }
            }
            catch (LoginException le) {
                throw new FailedLoginException("Login failed: " + le.getMessage());
            }
        }
        if ((authorizationPolicy = authorizationPolicies.get(0)) != null && authorizationPolicy.getAccessControl() == AuthorizationPolicy.AcessControl.allow) {
            String requiredRole;
            AccessControlContext acc = ContextManager.getCurrentContext();
            boolean isAllowed = false;
            Iterator<String> i$ = authorizationPolicy.getRoleNames().iterator();
            while (i$.hasNext() && !(isAllowed = this.isUserInRole(acc, requiredRole = i$.next()))) {
            }
            if (!isAllowed) {
                throw new LoginException("Insufficient access rights !");
            }
        }
    }

    public boolean isUserInRole(AccessControlContext acc, String role) {
        try {
            acc.checkPermission((Permission)new WebRoleRefPermission("", role));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

