/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.tuscany.sca.policy.SecurityUtil;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;

public class LDAPRealmAuthenticationCallbackHandler
implements CallbackHandler {
    private final Subject subject;

    public LDAPRealmAuthenticationCallbackHandler(Subject subject) {
        this.subject = subject;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        BasicAuthenticationPrincipal principal = SecurityUtil.getPrincipal(this.subject, BasicAuthenticationPrincipal.class);
        if (principal != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(principal.getName());
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(principal.getPassword().toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unsupported Callback!");
            }
        }
    }
}

