/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authorization.AuthorizationPolicy;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationInterceptor;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationPolicy;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandler;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRealmAuthenticationImplementationPolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private Implementation implementation;
    private LDAPSecurityHandler securityHandler;

    public LDAPRealmAuthenticationImplementationPolicyProvider(RuntimeComponent component, Implementation implementation, LDAPSecurityHandler securityHandler) {
        this.component = component;
        this.implementation = implementation;
        this.securityHandler = securityHandler;
    }

    @Override
    public String getPhase() {
        return "implementation.policy";
    }

    @Override
    public Interceptor createInterceptor(Operation operation) {
        List<LDAPRealmAuthenticationPolicy> policies = this.findAuthenticationPolicies(operation);
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        return new LDAPRealmAuthenticationInterceptor(this.securityHandler, this.findAuthenticationPolicies(operation), this.findAuthorizationPolicies(operation));
    }

    private List<LDAPRealmAuthenticationPolicy> findAuthenticationPolicies(Operation op) {
        ArrayList<LDAPRealmAuthenticationPolicy> polices = new ArrayList<LDAPRealmAuthenticationPolicy>();
        ConfiguredOperation configuredOperation = this.findOperation(op);
        if (configuredOperation != null && configuredOperation.getPolicySets().size() > 0) {
            for (PolicySet ps : configuredOperation.getPolicySets()) {
                for (Object p : ps.getPolicies()) {
                    if (!(p instanceof LDAPRealmAuthenticationPolicy)) continue;
                    polices.add((LDAPRealmAuthenticationPolicy)p);
                }
            }
        }
        if (polices.size() == 0) {
            if (this.implementation instanceof OperationsConfigurator) {
                OperationsConfigurator operationsConfigurator = (OperationsConfigurator)((Object)this.implementation);
                for (ConfiguredOperation cop : operationsConfigurator.getConfiguredOperations()) {
                    if (cop == null || cop.getName() == null || !cop.getName().equals(op.getName())) continue;
                    for (PolicySet ps : cop.getPolicySets()) {
                        for (Object p : ps.getPolicies()) {
                            if (!LDAPRealmAuthenticationPolicy.class.isInstance(p)) continue;
                            polices.add((LDAPRealmAuthenticationPolicy)p);
                        }
                    }
                }
            }
            List<PolicySet> policySets = this.component.getPolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!LDAPRealmAuthenticationPolicy.class.isInstance(p)) continue;
                    polices.add((LDAPRealmAuthenticationPolicy)p);
                }
            }
        }
        return polices;
    }

    private List<AuthorizationPolicy> findAuthorizationPolicies(Operation op) {
        ArrayList<AuthorizationPolicy> polices = new ArrayList<AuthorizationPolicy>();
        ConfiguredOperation configuredOperation = this.findOperation(op);
        if (configuredOperation != null && configuredOperation.getPolicySets().size() > 0) {
            for (PolicySet ps : configuredOperation.getPolicySets()) {
                for (Object p : ps.getPolicies()) {
                    if (!(p instanceof AuthorizationPolicy)) continue;
                    polices.add((AuthorizationPolicy)p);
                }
            }
        }
        if (polices.size() == 0) {
            if (this.implementation instanceof OperationsConfigurator) {
                OperationsConfigurator operationsConfigurator = (OperationsConfigurator)((Object)this.implementation);
                for (ConfiguredOperation cop : operationsConfigurator.getConfiguredOperations()) {
                    if (cop == null || cop.getName() == null || !cop.getName().equals(op.getName())) continue;
                    for (PolicySet ps : cop.getPolicySets()) {
                        for (Object p : ps.getPolicies()) {
                            if (!AuthorizationPolicy.class.isInstance(p)) continue;
                            polices.add((AuthorizationPolicy)p);
                        }
                    }
                }
            }
            List<PolicySet> policySets = this.component.getPolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!AuthorizationPolicy.class.isInstance(p)) continue;
                    polices.add((AuthorizationPolicy)p);
                }
            }
        }
        return polices;
    }

    private ConfiguredOperation findOperation(Operation operation) {
        ConfiguredOperation configuredOperation = null;
        for (ConfiguredOperation cOperation : ((OperationsConfigurator)((Object)this.component)).getConfiguredOperations()) {
            if (!cOperation.getName().equals(operation.getName())) continue;
            configuredOperation = cOperation;
            break;
        }
        return configuredOperation;
    }
}

