/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http;

import java.util.List;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.authorization.AuthorizationPolicy;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationPolicy;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandler;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRealmAuthenticationInterceptor
implements Interceptor {
    private LDAPSecurityHandler securityHandler;
    private List<LDAPRealmAuthenticationPolicy> authenticationPolicies;
    private List<AuthorizationPolicy> authorizationPolicies;
    private Invoker next;

    public LDAPRealmAuthenticationInterceptor(LDAPSecurityHandler securityHandler, List<LDAPRealmAuthenticationPolicy> authenticationPolicies, List<AuthorizationPolicy> authorizationPolicies) {
        this.securityHandler = securityHandler;
        this.authenticationPolicies = authenticationPolicies;
        this.authorizationPolicies = authorizationPolicies;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }

    @Override
    public Message invoke(Message msg) {
        try {
            this.securityHandler.handleSecurity(msg, this.authenticationPolicies, this.authorizationPolicies);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return this.getNext().invoke(msg);
    }
}

