/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRealmAuthenticationPolicyProcessor
implements StAXArtifactProcessor<LDAPRealmAuthenticationPolicy> {
    static final QName REALM_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "realm");
    public static final QName REALM_CONFIGURATION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "realmConfigurationName");
    private Monitor monitor;

    public LDAPRealmAuthenticationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-security-http-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public Class<LDAPRealmAuthenticationPolicy> getModelType() {
        return LDAPRealmAuthenticationPolicy.class;
    }

    @Override
    public QName getArtifactType() {
        return LDAPRealmAuthenticationPolicy.NAME;
    }

    @Override
    public LDAPRealmAuthenticationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        LDAPRealmAuthenticationPolicy policy = new LDAPRealmAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    String realmConfigurationName;
                    String realmName;
                    name = reader.getName();
                    if (name.equals(REALM_QNAME) && (realmName = reader.getElementText()) != null) {
                        policy.setRealmName(realmName.trim());
                    }
                    if (!name.equals(REALM_CONFIGURATION_QNAME) || (realmConfigurationName = reader.getElementText()) == null) break;
                    policy.setRealmConfigurationName(realmConfigurationName.trim());
                }
            }
            if (event == 2 && LDAPRealmAuthenticationPolicy.NAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    @Override
    public void write(LDAPRealmAuthenticationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, LDAPRealmAuthenticationPolicy.NAME.getLocalPart(), LDAPRealmAuthenticationPolicy.NAME.getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        writer.writeEndElement();
    }

    @Override
    public void resolve(LDAPRealmAuthenticationPolicy policy, ModelResolver resolver) throws ContributionResolveException {
    }
}

