/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationImplementationPolicyProvider;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationPolicy;
import org.apache.tuscany.sca.policy.security.http.LDAPRealmAuthenticationServicePolicyProvider;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandler;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandlerExtensionPoint;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRealmAuthenticationPolicyProviderFactory
implements PolicyProviderFactory<LDAPRealmAuthenticationPolicy> {
    private LDAPSecurityHandler securityHandler;

    public LDAPRealmAuthenticationPolicyProviderFactory(ExtensionPointRegistry registry) {
        LDAPSecurityHandlerExtensionPoint securityHandlerExtensionPoint = registry.getExtensionPoint(LDAPSecurityHandlerExtensionPoint.class);
        if (securityHandlerExtensionPoint.getLDAPSecurityHandlers().size() > 0) {
            this.securityHandler = securityHandlerExtensionPoint.getLDAPSecurityHandlers().get(0);
        }
    }

    @Override
    public Class<LDAPRealmAuthenticationPolicy> getModelType() {
        return LDAPRealmAuthenticationPolicy.class;
    }

    @Override
    public PolicyProvider createImplementationPolicyProvider(RuntimeComponent component, Implementation implementation) {
        return new LDAPRealmAuthenticationImplementationPolicyProvider(component, implementation, this.securityHandler);
    }

    @Override
    public PolicyProvider createReferencePolicyProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        return null;
    }

    @Override
    public PolicyProvider createServicePolicyProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        return new LDAPRealmAuthenticationServicePolicyProvider(component, service, binding, this.securityHandler);
    }
}

