/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http.extensibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandler;
import org.apache.tuscany.sca.policy.security.http.extensibility.LDAPSecurityHandlerExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLDAPSecurityExtensionPoint
implements LDAPSecurityHandlerExtensionPoint {
    private List<LDAPSecurityHandler> securityHandlers = new ArrayList<LDAPSecurityHandler>();
    private ExtensionPointRegistry extensionPoints;
    private Monitor monitor = null;
    private boolean loaded = false;

    public DefaultLDAPSecurityExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
    }

    @Override
    public void addLDAPSecurityHandler(LDAPSecurityHandler securityHandler) {
        this.securityHandlers.add(securityHandler);
    }

    @Override
    public void removeLDAPSecurityHandler(LDAPSecurityHandler securityHandler) {
        this.securityHandlers.remove(securityHandler);
    }

    @Override
    public List<LDAPSecurityHandler> getLDAPSecurityHandlers() {
        this.loadHandlers();
        return this.securityHandlers;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            Problem problem = this.monitor.createProblem(this.getClass().getName(), null, Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private synchronized void loadHandlers() {
        if (this.loaded) {
            return;
        }
        Set<ServiceDeclaration> handlerDeclarations = null;
        try {
            handlerDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(LDAPSecurityHandler.class);
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", handlerDeclarations, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : handlerDeclarations) {
            LDAPSecurityHandler securityHandler = null;
            try {
                Class<?> securityHandlerClass = processorDeclaration.loadClass();
                securityHandler = (LDAPSecurityHandler)securityHandlerClass.newInstance();
            }
            catch (Exception e) {
                IllegalStateException ie = new IllegalStateException(e);
                this.error("IllegalStateException", securityHandler, ie);
                throw ie;
            }
            this.addLDAPSecurityHandler(securityHandler);
        }
        this.loaded = true;
    }
}

