/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.http.util;

import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;

public class HttpSecurityUtil {
    public static boolean hasAuthorizationHeader(HttpServletRequest request) {
        boolean result = false;
        if (request.getHeader("Authorization") != null) {
            result = true;
        }
        return result;
    }

    public static String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public static Subject getSubject(Message msg) {
        Subject subject = null;
        HttpServletRequest request = null;
        for (Object header : msg.getHeaders()) {
            if (header instanceof Subject) {
                subject = (Subject)header;
                break;
            }
            if (!(header instanceof HttpServletRequest)) continue;
            request = (HttpServletRequest)header;
        }
        if (subject == null & request != null && HttpSecurityUtil.hasAuthorizationHeader(request)) {
            subject = HttpSecurityUtil.getSubject(HttpSecurityUtil.getAuthorizationHeader(request));
        }
        if (subject == null) {
            subject = new Subject();
            msg.getHeaders().add(subject);
        }
        return subject;
    }

    public static Subject getSubject(String httpAuthorizationHeader) {
        String credentials;
        String userAndPassword;
        int colon;
        String basic;
        StringTokenizer tokens;
        Subject subject = new Subject();
        String user = null;
        String password = null;
        if (httpAuthorizationHeader != null && (tokens = new StringTokenizer(httpAuthorizationHeader)).hasMoreTokens() && (basic = tokens.nextToken()).equalsIgnoreCase("Basic") && (colon = (userAndPassword = new String(Base64.decodeBase64((byte[])(credentials = tokens.nextToken()).getBytes()))).indexOf(":")) != -1) {
            user = userAndPassword.substring(0, colon);
            password = userAndPassword.substring(colon + 1);
        }
        if (user != null && password != null) {
            BasicAuthenticationPrincipal principal = new BasicAuthenticationPrincipal(user, password);
            subject.getPrincipals().add(principal);
        }
        return subject;
    }
}

